/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.examples.v1;

import io.fabric8.istio.api.api.networking.v1alpha3.ServiceEntryLocation;
import io.fabric8.istio.api.api.networking.v1alpha3.ServicePort;
import io.fabric8.istio.api.api.networking.v1alpha3.ServicePortBuilder;
import io.fabric8.istio.api.examples.v1.ClientFactory;
import io.fabric8.istio.api.networking.v1.ServiceEntryBuilder;
import io.fabric8.istio.api.networking.v1.ServiceEntryFluent;
import io.fabric8.istio.api.networking.v1.ServiceEntryList;
import io.fabric8.istio.client.IstioClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;

public class ServiceEntryExample {
    private static final String NAMESPACE = "test";

    public static void main(String[] args) {
        try {
            IstioClient client = ClientFactory.newClient(args);
            ServiceEntryExample.createResource(client);
            System.exit(0);
        }
        catch (KubernetesClientException ex) {
            System.err.println("Failed with " + ex.getMessage());
            System.exit(1);
        }
    }

    public static void createResource(IstioClient client) {
        System.out.println("Creating a service entry");
        ((Resource)((NonNamespaceOperation)client.v1().serviceEntries().inNamespace(NAMESPACE)).resource((Object)((ServiceEntryBuilder)((ServiceEntryFluent.SpecNested)((ServiceEntryFluent.SpecNested)((ServiceEntryFluent.SpecNested)((ServiceEntryBuilder)((ServiceEntryFluent.MetadataNested)new ServiceEntryBuilder().withNewMetadata().withName("external-svc-https")).endMetadata()).withNewSpec().withHosts(new String[]{"api.dropboxapi.com", "www.googleapis.com"})).withLocation(ServiceEntryLocation.MESH_INTERNAL)).withPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("https")).withProtocol("TLS")).withNumber(Long.valueOf(443L))).build()})).endSpec()).build())).create();
        System.out.println("Listing Virtual Service Instances:");
        ServiceEntryList list = (ServiceEntryList)((NonNamespaceOperation)client.v1().serviceEntries().inNamespace(NAMESPACE)).list();
        list.getItems().forEach(b -> System.out.println(b.getMetadata().getName()));
        System.out.println("Done");
    }
}

