/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.examples.v1;

import io.fabric8.istio.api.api.networking.v1alpha3.DestinationRuleFluent;
import io.fabric8.istio.api.api.networking.v1alpha3.IsLoadBalancerSettingsLbPolicy;
import io.fabric8.istio.api.api.networking.v1alpha3.LoadBalancerSettingsBuilder;
import io.fabric8.istio.api.api.networking.v1alpha3.LoadBalancerSettingsSimple;
import io.fabric8.istio.api.api.networking.v1alpha3.LoadBalancerSettingsSimpleLB;
import io.fabric8.istio.api.examples.v1.ClientFactory;
import io.fabric8.istio.api.networking.v1.DestinationRuleBuilder;
import io.fabric8.istio.api.networking.v1.DestinationRuleFluent;
import io.fabric8.istio.api.networking.v1.DestinationRuleList;
import io.fabric8.istio.client.IstioClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;

public class DestinationRuleExample {
    private static final String NAMESPACE = "test";

    public static void main(String[] args) {
        try {
            IstioClient client = ClientFactory.newClient(args);
            DestinationRuleExample.createResource(client);
            System.exit(0);
        }
        catch (KubernetesClientException ex) {
            System.err.println("Failed with " + ex.getMessage());
            System.exit(1);
        }
    }

    public static void createResource(IstioClient client) {
        System.out.println("Creating a destination rule");
        ((Resource)((NonNamespaceOperation)client.v1().destinationRules().inNamespace(NAMESPACE)).resource((Object)((DestinationRuleBuilder)((DestinationRuleFluent.SpecNested)((DestinationRuleFluent.TrafficPolicyNested)((DestinationRuleFluent.SpecNested)((DestinationRuleBuilder)((DestinationRuleFluent.MetadataNested)new DestinationRuleBuilder().withNewMetadata().withName("reviews-route")).endMetadata()).withNewSpec().withHost("ratings.prod.svc.cluster.local")).withNewTrafficPolicy().withLoadBalancer(((LoadBalancerSettingsBuilder)new LoadBalancerSettingsBuilder().withLbPolicy((IsLoadBalancerSettingsLbPolicy)new LoadBalancerSettingsSimple(LoadBalancerSettingsSimpleLB.RANDOM))).build())).endTrafficPolicy()).endSpec()).build())).create();
        System.out.println("Listing destination rules instances:");
        DestinationRuleList list = (DestinationRuleList)((NonNamespaceOperation)client.v1().destinationRules().inNamespace(NAMESPACE)).list();
        list.getItems().forEach(b -> System.out.println(b.getMetadata().getName()));
        System.out.println("Done");
    }
}

