/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.repo.git.resteasy;

import io.fabric8.repo.git.GitRepoClientSupport;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.DatatypeConverter;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.plugins.providers.DefaultTextPlain;
import org.jboss.resteasy.plugins.providers.FileProvider;
import org.jboss.resteasy.plugins.providers.InputStreamProvider;
import org.jboss.resteasy.plugins.providers.StringTextStar;
import org.jboss.resteasy.plugins.providers.jackson.Jackson2JsonpInterceptor;
import org.jboss.resteasy.plugins.providers.jackson.ResteasyJackson2Provider;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ResteasyGitRepoClient
extends GitRepoClientSupport {
    public static ResteasyGitRepoClient createWithContextClassLoader(String address, String username, String password) {
        Thread.currentThread().setContextClassLoader(ResteasyGitRepoClient.class.getClassLoader());
        return new ResteasyGitRepoClient(address, username, password);
    }

    public ResteasyGitRepoClient(String address, String username, String password) {
        super(address, username, password);
    }

    protected <T> T createWebClient(Class<T> clientType) {
        String address = this.getAddress();
        ResteasyProviderFactory providerFactory = ResteasyProviderFactory.getInstance();
        providerFactory.register(ResteasyJackson2Provider.class);
        providerFactory.register(Jackson2JsonpInterceptor.class);
        providerFactory.register(StringTextStar.class);
        providerFactory.register(DefaultTextPlain.class);
        providerFactory.register(FileProvider.class);
        providerFactory.register(InputStreamProvider.class);
        providerFactory.register((Object)new Authenticator());
        providerFactory.register(clientType);
        ResteasyClientBuilder builder = new ResteasyClientBuilder();
        builder.providerFactory(providerFactory);
        builder.connectionPoolSize(3);
        ResteasyClient client = builder.build();
        ResteasyWebTarget target = (ResteasyWebTarget)client.target(address);
        return (T)target.proxy(clientType);
    }

    protected class Authenticator
    implements ClientRequestFilter {
        protected Authenticator() {
        }

        public void filter(ClientRequestContext requestContext) throws IOException {
            MultivaluedMap headers = requestContext.getHeaders();
            String basicAuthentication = this.getBasicAuthentication();
            headers.add((Object)"Authorization", (Object)basicAuthentication);
        }

        private String getBasicAuthentication() {
            String token = ResteasyGitRepoClient.this.getUsername() + ":" + ResteasyGitRepoClient.this.getPassword();
            try {
                return "Basic " + DatatypeConverter.printBase64Binary((byte[])token.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException("Cannot encode with UTF-8", ex);
            }
        }
    }
}

