/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.repo.gitlab;

import io.fabric8.repo.gitlab.CreateGroupDTO;
import io.fabric8.repo.gitlab.GitlabApi;
import io.fabric8.repo.gitlab.GitlabClientSupport;
import io.fabric8.repo.gitlab.GroupDTO;
import io.fabric8.repo.gitlab.IssueDTO;
import io.fabric8.repo.gitlab.NamespaceDTO;
import io.fabric8.repo.gitlab.ProjectDTO;
import io.fabric8.utils.Strings;
import io.fabric8.utils.cxf.WebClients;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;

public class GitlabClient
extends GitlabClientSupport
implements GitlabApi {
    public GitlabClient(String address, String username) {
        super(address, username);
    }

    public GitlabClient(String address, String username, String password) {
        super(address, username, password);
    }

    @Override
    @GET
    @Path(value="namespaces")
    public List<NamespaceDTO> getNamespaces() {
        return this.getApi().getNamespaces();
    }

    @Override
    @GET
    @Path(value="groups")
    public List<GroupDTO> getGroups() {
        return this.getApi().getGroups();
    }

    @Override
    @POST
    @Path(value="group")
    public GroupDTO createGroup(CreateGroupDTO dto) {
        return this.getApi().createGroup(dto);
    }

    @Override
    @GET
    @Path(value="groups/{groupId}/projects")
    public List<ProjectDTO> getProjects(Long projectId) {
        return this.getApi().getProjects(projectId);
    }

    @Override
    @GET
    @Path(value="projects")
    public List<ProjectDTO> getProjects() {
        return this.getApi().getProjects();
    }

    @Override
    @GET
    @Path(value="projects/{projectId}")
    public List<ProjectDTO> getProject(Long projectId) {
        return this.getApi().getProject(projectId);
    }

    @Override
    @GET
    @Path(value="issues")
    public List<IssueDTO> getIssues() {
        return this.getApi().getIssues();
    }

    @Override
    @GET
    @Path(value="groups/{groupId}/issues")
    public List<IssueDTO> getGroupIssues(Long groupId) {
        return this.getApi().getGroupIssues(groupId);
    }

    @Override
    @GET
    @Path(value="projects/{projectId}/issues")
    public List<IssueDTO> getProjectIssue(Long projectId) {
        return this.getApi().getProjectIssue(projectId);
    }

    @Override
    protected <T> T createWebClient(Class<T> clientType) {
        List providers = WebClients.createProviders();
        if (Strings.isNotBlank((String)this.privateToken)) {
            providers.add(WebClients.createPrivateTokenFilter((String)this.privateToken));
        }
        WebClient webClient = WebClient.create((String)this.address, (List)providers);
        WebClients.disableSslChecks((WebClient)webClient);
        WebClients.configureUserAndPassword((WebClient)webClient, (String)this.username, (String)this.password);
        return (T)JAXRSClientFactory.fromClient((Client)webClient, clientType);
    }
}

