/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.repo.git;

import io.fabric8.repo.git.CreateRepositoryDTO;
import io.fabric8.repo.git.CreateWebhookDTO;
import io.fabric8.repo.git.GitApi;
import io.fabric8.repo.git.OrganisationDTO;
import io.fabric8.repo.git.RepositoryDTO;
import io.fabric8.repo.git.WebHookDTO;
import java.util.List;

public abstract class GitRepoClientSupport {
    protected final String address;
    protected final String username;
    protected final String password;
    private GitApi api;

    public GitRepoClientSupport(String address, String username, String password) {
        this.address = address;
        this.password = password;
        this.username = username;
    }

    public List<RepositoryDTO> listRepositories() {
        return this.getApi().listRepositories();
    }

    public List<RepositoryDTO> listOrganisationRepositories(String organisation) {
        return this.getApi().listOrganisationRepositories(organisation);
    }

    public List<OrganisationDTO> listUserOrganisations() {
        return this.getApi().listUserOrganisations();
    }

    public WebHookDTO createWebhook(String owner, String repo, CreateWebhookDTO dto) {
        return this.getApi().createWebhook(owner, repo, dto);
    }

    public RepositoryDTO createRepository(CreateRepositoryDTO createRepository) {
        return this.getApi().createRepository(createRepository);
    }

    protected GitApi getApi() {
        if (this.api == null) {
            this.api = this.createWebClient(GitApi.class);
        }
        return this.api;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    protected abstract <T> T createWebClient(Class<T> var1);
}

