/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.servlet;

import io.fabric8.common.util.IOHelpers;
import io.fabric8.gateway.model.HttpProxyRuleBase;
import io.fabric8.gateway.servlet.HttpClientRequestFacade;
import io.fabric8.gateway.servlet.HttpMappingResult;
import io.fabric8.gateway.servlet.HttpMappingRuleResolver;
import io.fabric8.gateway.servlet.ProxyDetails;
import io.fabric8.gateway.servlet.support.ProxySupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProxyServlet
extends HttpServlet {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProxyServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String STRING_LOCATION_HEADER = "Location";
    private static final String STRING_CONTENT_TYPE_HEADER_NAME = "Content-Type";
    private static final String STRING_CONTENT_LENGTH_HEADER_NAME = "Content-Length";
    private static final String[] IGNORE_HEADER_NAMES = new String[]{"Content-Length", "Origin", "Authorization"};
    private static final String STRING_HOST_HEADER_NAME = "Host";
    private static final File FILE_UPLOAD_TEMP_DIRECTORY = new File(System.getProperty("java.io.tmpdir"));
    private HttpMappingRuleResolver resolver = new HttpMappingRuleResolver();
    private int intMaxFileUploadSize = 0x500000;

    public void init(ServletConfig config) throws ServletException {
        HttpProxyRuleBase ruleBase = new HttpProxyRuleBase();
        this.loadRuleBase(config, ruleBase);
        this.resolver.setMappingRules(ruleBase);
    }

    protected abstract void loadRuleBase(ServletConfig var1, HttpProxyRuleBase var2) throws ServletException;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        ProxyDetails proxyDetails = this.createProxyDetails(httpServletRequest, httpServletResponse);
        if (!proxyDetails.isValid()) {
            this.noMappingFound(httpServletRequest, httpServletResponse);
        } else {
            GetMethod getMethodProxyRequest = new GetMethod(proxyDetails.getStringProxyURL());
            this.setProxyRequestHeaders(proxyDetails, httpServletRequest, (HttpMethod)getMethodProxyRequest);
            this.executeProxyRequest(proxyDetails, (HttpMethod)getMethodProxyRequest, httpServletRequest, httpServletResponse);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        ProxyDetails proxyDetails = this.createProxyDetails(httpServletRequest, httpServletResponse);
        if (!proxyDetails.isValid()) {
            this.noMappingFound(httpServletRequest, httpServletResponse);
        } else {
            PostMethod postMethodProxyRequest = new PostMethod(proxyDetails.getStringProxyURL());
            this.setProxyRequestHeaders(proxyDetails, httpServletRequest, (HttpMethod)postMethodProxyRequest);
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)httpServletRequest)) {
                this.handleMultipartPost(postMethodProxyRequest, httpServletRequest);
            } else {
                this.handleStandardPost(postMethodProxyRequest, httpServletRequest);
            }
            this.executeProxyRequest(proxyDetails, (HttpMethod)postMethodProxyRequest, httpServletRequest, httpServletResponse);
        }
    }

    protected ProxyDetails createProxyDetails(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String destinationUrl;
        HttpMappingResult mappingRule = this.getResolver().findMappingRule(httpServletRequest, httpServletResponse);
        if (mappingRule != null && (destinationUrl = mappingRule.getDestinationUrl(new HttpClientRequestFacade(httpServletRequest, httpServletResponse))) != null) {
            return new ProxyDetails(true, destinationUrl);
        }
        return new ProxyDetails(false, null);
    }

    protected void noMappingFound(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.sendError(404, "No endpoint could be found for " + httpServletRequest.getRequestURI());
    }

    private void handleMultipartPost(PostMethod postMethodProxyRequest, HttpServletRequest httpServletRequest) throws ServletException {
        DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
        diskFileItemFactory.setSizeThreshold(this.getMaxFileUploadSize());
        diskFileItemFactory.setRepository(FILE_UPLOAD_TEMP_DIRECTORY);
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
        try {
            List listFileItems = servletFileUpload.parseRequest(httpServletRequest);
            ArrayList<Object> listParts = new ArrayList<Object>();
            for (FileItem fileItemCurrent : listFileItems) {
                if (fileItemCurrent.isFormField()) {
                    StringPart stringPart = new StringPart(fileItemCurrent.getFieldName(), fileItemCurrent.getString());
                    listParts.add(stringPart);
                    continue;
                }
                FilePart filePart = new FilePart(fileItemCurrent.getFieldName(), (PartSource)new ByteArrayPartSource(fileItemCurrent.getName(), fileItemCurrent.get()));
                listParts.add(filePart);
            }
            MultipartRequestEntity multipartRequestEntity = new MultipartRequestEntity(listParts.toArray(new Part[0]), postMethodProxyRequest.getParams());
            postMethodProxyRequest.setRequestEntity((RequestEntity)multipartRequestEntity);
            postMethodProxyRequest.setRequestHeader(STRING_CONTENT_TYPE_HEADER_NAME, multipartRequestEntity.getContentType());
        }
        catch (FileUploadException fileUploadException) {
            throw new ServletException((Throwable)fileUploadException);
        }
    }

    private void handleStandardPost(PostMethod postMethodProxyRequest, HttpServletRequest httpServletRequest) throws IOException {
        Map mapPostParameters = httpServletRequest.getParameterMap();
        ArrayList<NameValuePair> listNameValuePairs = new ArrayList<NameValuePair>();
        for (String stringParameterName : mapPostParameters.keySet()) {
            String[] stringArrayParameterValues;
            for (String stringParamterValue : stringArrayParameterValues = (String[])mapPostParameters.get(stringParameterName)) {
                NameValuePair nameValuePair = new NameValuePair(stringParameterName, stringParamterValue);
                listNameValuePairs.add(nameValuePair);
            }
        }
        StringRequestEntity entity = null;
        String contentType = httpServletRequest.getContentType();
        if (contentType != null && ((contentType = contentType.toLowerCase()).contains("json") || contentType.contains("xml") || contentType.contains("application") || contentType.contains("text"))) {
            String body = IOHelpers.readFully((Reader)httpServletRequest.getReader());
            entity = new StringRequestEntity(body, contentType, httpServletRequest.getCharacterEncoding());
            postMethodProxyRequest.setRequestEntity((RequestEntity)entity);
        }
        NameValuePair[] parameters = listNameValuePairs.toArray(new NameValuePair[0]);
        if (entity == null) {
            postMethodProxyRequest.setRequestBody(parameters);
        }
    }

    private void executeProxyRequest(ProxyDetails proxyDetails, HttpMethod httpMethodProxyRequest, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String length;
        boolean noData;
        Header[] headerArrayResponse;
        httpMethodProxyRequest.setFollowRedirects(false);
        HttpClient httpClient = proxyDetails.createHttpClient(httpMethodProxyRequest);
        int intProxyResponseCode = httpClient.executeMethod(httpMethodProxyRequest);
        if (intProxyResponseCode >= 300 && intProxyResponseCode < 304) {
            String stringStatusCode = Integer.toString(intProxyResponseCode);
            String stringLocation = httpMethodProxyRequest.getResponseHeader(STRING_LOCATION_HEADER).getValue();
            if (stringLocation == null) {
                throw new ServletException("Received status code: " + stringStatusCode + " but no " + STRING_LOCATION_HEADER + " header was found in the response");
            }
            String stringMyHostName = httpServletRequest.getServerName();
            if (httpServletRequest.getServerPort() != 80) {
                stringMyHostName = stringMyHostName + ":" + httpServletRequest.getServerPort();
            }
            stringMyHostName = stringMyHostName + httpServletRequest.getContextPath();
            httpServletResponse.sendRedirect(stringLocation.replace(proxyDetails.getProxyHostAndPort() + proxyDetails.getProxyPath(), stringMyHostName));
            return;
        }
        if (intProxyResponseCode == 304) {
            httpServletResponse.setIntHeader(STRING_CONTENT_LENGTH_HEADER_NAME, 0);
            httpServletResponse.setStatus(304);
            return;
        }
        httpServletResponse.setStatus(intProxyResponseCode);
        for (Header header : headerArrayResponse = httpMethodProxyRequest.getResponseHeaders()) {
            if (ProxySupport.isHopByHopHeader(header.getName())) continue;
            httpServletResponse.setHeader(header.getName(), header.getValue());
        }
        int code = httpMethodProxyRequest.getStatusCode();
        boolean bl = noData = code == 204;
        if (!noData && (length = httpServletRequest.getHeader(STRING_CONTENT_LENGTH_HEADER_NAME)) != null && "0".equals(length.trim())) {
            noData = true;
        }
        LOG.trace("Response has data? {}", (Object)(!noData ? 1 : 0));
        if (!noData) {
            int intNextByte;
            InputStream inputStreamProxyResponse = httpMethodProxyRequest.getResponseBodyAsStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStreamProxyResponse);
            ServletOutputStream outputStreamClientResponse = httpServletResponse.getOutputStream();
            while ((intNextByte = bufferedInputStream.read()) != -1) {
                outputStreamClientResponse.write(intNextByte);
            }
        }
    }

    public String getServletInfo() {
        return "Fabric8 Gateway Proxy Servlet";
    }

    public HttpMappingRuleResolver getResolver() {
        return this.resolver;
    }

    private void setProxyRequestHeaders(ProxyDetails proxyDetails, HttpServletRequest httpServletRequest, HttpMethod httpMethodProxyRequest) {
        Enumeration enumerationOfHeaderNames = httpServletRequest.getHeaderNames();
        while (enumerationOfHeaderNames.hasMoreElements()) {
            String stringHeaderName = (String)enumerationOfHeaderNames.nextElement();
            if (stringHeaderName.equalsIgnoreCase(STRING_CONTENT_LENGTH_HEADER_NAME) || stringHeaderName.equalsIgnoreCase("Authorization") || stringHeaderName.equalsIgnoreCase("Origin") || ProxySupport.isHopByHopHeader(stringHeaderName)) continue;
            Enumeration enumerationOfHeaderValues = httpServletRequest.getHeaders(stringHeaderName);
            while (enumerationOfHeaderValues.hasMoreElements()) {
                String stringHeaderValue = (String)enumerationOfHeaderValues.nextElement();
                if (stringHeaderName.equalsIgnoreCase(STRING_HOST_HEADER_NAME)) {
                    stringHeaderValue = proxyDetails.getProxyHostAndPort();
                }
                Header header = new Header(stringHeaderName, stringHeaderValue);
                httpMethodProxyRequest.setRequestHeader(header);
            }
        }
    }

    private int getMaxFileUploadSize() {
        return this.intMaxFileUploadSize;
    }

    private void setMaxFileUploadSize(int intMaxFileUploadSizeNew) {
        this.intMaxFileUploadSize = intMaxFileUploadSizeNew;
    }
}

