/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.model;

import io.fabric8.gateway.loadbalancer.ClientRequestFacade;
import io.fabric8.gateway.model.UriTemplateDefinition;
import io.fabric8.gateway.model.loadbalancer.LoadBalancerDefinition;
import io.fabric8.gateway.model.loadbalancer.RoundRobinLoadBalanceDefinition;
import io.fabric8.gateway.support.MappingResult;
import io.fabric8.gateway.support.UriTemplate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyRule {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpProxyRule.class);
    private UriTemplateDefinition uriTemplate;
    private boolean reverseHeaders = true;
    private LoadBalancerDefinition loadBalancer = new RoundRobinLoadBalanceDefinition();
    private Set<UriTemplateDefinition> destinationUriTemplates = new HashSet<UriTemplateDefinition>();
    private String cookiePath;
    private String cookieDomain;

    public HttpProxyRule() {
    }

    public HttpProxyRule(String uriTemplate) {
        this.uriTemplate = new UriTemplateDefinition(uriTemplate);
    }

    public MappingResult matches(String[] paths) {
        UriTemplate template = this.getUriTemplateObject();
        if (template == null) {
            LOG.warn("getUriTemplateObject() returned null!");
            return null;
        }
        return template.matches(paths, this);
    }

    public UriTemplateDefinition chooseBackEndService(ClientRequestFacade requestFacade) {
        UriTemplateDefinition loadBalancer = this.getLoadBalancer().getLoadBalancer();
        ArrayList<UriTemplateDefinition> uriDefList = new ArrayList<UriTemplateDefinition>(this.destinationUriTemplates);
        return loadBalancer.choose(uriDefList, requestFacade);
    }

    public HttpProxyRule to(String destinationUriTemplate) {
        this.to(new UriTemplateDefinition(destinationUriTemplate));
        return this;
    }

    public HttpProxyRule to(UriTemplateDefinition templateDefinition) {
        this.destinationUriTemplates.add(templateDefinition);
        return this;
    }

    public UriTemplate getUriTemplateObject() {
        return this.getUriTemplate().getUriTemplateObject();
    }

    public UriTemplateDefinition getUriTemplate() {
        return this.uriTemplate;
    }

    public HttpProxyRule setUriTemplate(UriTemplateDefinition uriTemplate) {
        this.uriTemplate = uriTemplate;
        return this;
    }

    public Set<UriTemplateDefinition> getDestinationUriTemplates() {
        return this.destinationUriTemplates;
    }

    public HttpProxyRule setDestinationUriTemplates(Set<UriTemplateDefinition> destinationUriTemplates) {
        this.destinationUriTemplates = destinationUriTemplates;
        return this;
    }

    public boolean isReverseHeaders() {
        return this.reverseHeaders;
    }

    public HttpProxyRule setReverseHeaders(boolean reverseHeaders) {
        this.reverseHeaders = reverseHeaders;
        return this;
    }

    public LoadBalancerDefinition getLoadBalancer() {
        return this.loadBalancer;
    }

    public HttpProxyRule setLoadBalancer(LoadBalancerDefinition loadBalancer) {
        this.loadBalancer = loadBalancer;
        return this;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public HttpProxyRule setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
        return this;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public HttpProxyRule setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
        return this;
    }
}

