/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.fabric.haproxy;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Profiles;
import io.fabric8.api.Version;
import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.common.util.Closeables;
import io.fabric8.common.util.Strings;
import io.fabric8.gateway.fabric.haproxy.model.BackEndServer;
import io.fabric8.gateway.fabric.haproxy.model.FrontEnd;
import io.fabric8.gateway.fabric.haproxy.model.OnValue;
import io.fabric8.gateway.handlers.http.HttpMappingRule;
import io.fabric8.gateway.handlers.http.MappedServices;
import io.fabric8.internal.Objects;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.mvel2.ParserContext;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={FabricHaproxyGateway.class})
@Component(name="io.fabric8.gateway.haproxy", immediate=true, metatype=true, policy=ConfigurationPolicy.REQUIRE, label="Fabric8 HAProxy Gateway", description="Automatically generates a haproxy configuration file to implement a reverse proxy from haproxy to any web services or web applications running inside the fabric")
public class FabricHaproxyGateway
extends AbstractComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(FabricHaproxyGateway.class);
    private static final String TEMPLATE_FILE_NAME = "io.fabric8.gateway.haproxy.config.mvel";
    @Reference
    private Configurer configurer;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, bind="setFabricService", unbind="unsetFabricService")
    private FabricService fabricService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_MULTIPLE, bind="setCurator", unbind="unsetCurator")
    private CuratorFramework curator;
    @Property(name="configFile", label="Config file location", description="The full file path of the generated configuration file created for haproxy to reuse")
    private String configFile;
    @Property(name="reloadCommand", label="Reload Haproxy Command", description="The command line to execute when the haproxy configuration file has been regenerated so that haproxy can be safely restarted")
    private String reloadCommand;
    @Property(name="reloadCommandDirectory", label="Reload Command Directory", description="The directory that should be used to run the reload command in")
    private String reloadCommandDirectory;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private Set<HttpMappingRule> mappingRuleConfigurations = new CopyOnWriteArraySet<HttpMappingRule>();
    private Runnable changeListener = new Runnable(){

        @Override
        public void run() {
            try {
                FabricHaproxyGateway.this.rewriteConfigurationFile();
                FabricHaproxyGateway.this.reloadHaproxy();
            }
            catch (Exception e) {
                LOG.warn("Failed to write haproxy config file: " + e, (Throwable)e);
            }
        }
    };
    private String templateText;
    @GuardedBy(value="this")
    private final ParserContext parserContext = new ParserContext();
    private CompiledTemplate template;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteConfigurationFile() throws IOException {
        LOG.info("Writing HAProxy file: " + this.configFile);
        File outFile = new File(this.configFile);
        outFile.getParentFile().mkdirs();
        PrintWriter writer = new PrintWriter(new FileWriter(outFile));
        try {
            Map<String, MappedServices> mappedServices = this.getMappedServices();
            CompiledTemplate compiledTemplate = this.getTemplate();
            Map<String, ?> data = this.createTemplateData();
            String renderedTemplate = TemplateRuntime.execute((CompiledTemplate)compiledTemplate, (Object)this.parserContext, data).toString();
            writer.println(renderedTemplate);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                LOG.debug("Caught while closing: " + e, (Throwable)e);
            }
        }
    }

    public void reloadHaproxy() throws Exception {
        if (Strings.isNotBlank((String)this.reloadCommand)) {
            LOG.info("Executing command: " + this.reloadCommand);
            HashMap<String, String> envVars = new HashMap<String, String>();
            envVars.putAll(System.getenv());
            envVars.put("FABRIC8_HAPROXY_CONFIG", this.configFile);
            ArrayList<String> envVarList = new ArrayList<String>();
            for (Map.Entry entry : envVars.entrySet()) {
                envVarList.add((String)entry.getKey() + "=" + (String)entry.getValue());
            }
            final String[] envVarArray = envVarList.toArray(new String[envVarList.size()]);
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Process process = null;
                    Runtime runtime = Runtime.getRuntime();
                    try {
                        if (Strings.isNotBlank((String)FabricHaproxyGateway.this.reloadCommandDirectory)) {
                            File directory = new File(FabricHaproxyGateway.this.reloadCommandDirectory);
                            process = runtime.exec(FabricHaproxyGateway.this.reloadCommand, envVarArray, directory);
                        } else {
                            process = runtime.exec(FabricHaproxyGateway.this.reloadCommand, envVarArray);
                        }
                        FabricHaproxyGateway.forEachLine(process.getInputStream(), "stdout", new OnValue<String>(){

                            @Override
                            public void onValue(String value) {
                                LOG.info(value);
                            }
                        });
                        FabricHaproxyGateway.forEachLine(process.getErrorStream(), "stderr", new OnValue<String>(){

                            @Override
                            public void onValue(String value) {
                                LOG.error(value);
                            }
                        });
                        try {
                            int exitCode = process.waitFor();
                            LOG.info("command exit code: " + exitCode);
                        }
                        catch (InterruptedException e) {
                            LOG.warn("Failed to wait for process exit code: " + e, (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Failed to create process: " + FabricHaproxyGateway.this.reloadCommand + ". " + e, (Throwable)e);
                    }
                    finally {
                        if (process != null) {
                            try {
                                process.destroy();
                            }
                            catch (Exception e) {
                                LOG.warn("Failed to destroy the process: " + e, (Throwable)e);
                            }
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forEachLine(InputStream inputStream, String nameOfStream, OnValue<String> lineCallback) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                lineCallback.onValue(line);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to process " + nameOfStream + ": " + e, (Throwable)e);
        }
        finally {
            Closeables.closeQuitely((Closeable)reader);
        }
    }

    protected Map<String, ?> createTemplateData() {
        HashMap answer = new HashMap();
        ArrayList<FrontEnd> frontEnds = new ArrayList<FrontEnd>();
        Set<Map.Entry<String, MappedServices>> entries = this.getMappedServices().entrySet();
        for (Map.Entry<String, MappedServices> entry : entries) {
            String uri = entry.getKey();
            MappedServices services = entry.getValue();
            String id = "b" + uri.replace('/', '_').replace('-', '_');
            while (id.endsWith("_")) {
                id = id.substring(0, id.length() - 1);
            }
            ArrayList<BackEndServer> backends = new ArrayList<BackEndServer>();
            FrontEnd frontEnd = new FrontEnd(id, uri, services, backends);
            frontEnds.add(frontEnd);
            List serviceUrls = services.getServiceUrls();
            for (String serviceUrl : serviceUrls) {
                URL url = null;
                try {
                    url = new URL(serviceUrl);
                }
                catch (MalformedURLException e) {
                    LOG.warn("Ignore bad URL: " + e);
                }
                if (url == null) continue;
                backends.add(new BackEndServer(url));
            }
        }
        answer.put("frontEnds", frontEnds);
        return answer;
    }

    protected CompiledTemplate getTemplate() {
        Profile overlayProfile;
        Profile effectiveProfile;
        byte[] bytes;
        String oldTemplateText = this.templateText;
        if (this.templateText == null && this.fabricService != null && (bytes = (effectiveProfile = Profiles.getEffectiveProfile((FabricService)this.fabricService, (Profile)(overlayProfile = this.fabricService.getCurrentContainer().getOverlayProfile()))).getFileConfiguration(TEMPLATE_FILE_NAME)) != null) {
            this.templateText = new String(bytes);
        }
        Objects.notNull((Object)this.templateText, (String)"Could not find template text in profile config file: io.fabric8.gateway.haproxy.config.mvel");
        if (this.template == null || oldTemplateText == null || !oldTemplateText.equals(this.templateText)) {
            this.template = TemplateCompiler.compileTemplate((String)this.templateText, (ParserContext)this.parserContext);
        }
        return this.template;
    }

    @Activate
    void activate(Map<String, ?> configuration) throws Exception {
        this.updateConfiguration(configuration);
        this.activateComponent();
    }

    @Modified
    void modified(Map<String, ?> configuration) throws Exception {
        this.deactivateInternal();
        this.updateConfiguration(configuration);
    }

    @Deactivate
    void deactivate() {
        this.deactivateInternal();
        this.deactivateComponent();
    }

    protected void updateConfiguration(Map<String, ?> configuration) throws Exception {
        this.configurer.configure(configuration, (Object)this, new String[0]);
    }

    protected void deactivateInternal() {
    }

    public void addMappingRuleConfiguration(HttpMappingRule mappingRuleConfiguration) {
        mappingRuleConfiguration.addChangeListener(this.changeListener);
        this.mappingRuleConfigurations.add(mappingRuleConfiguration);
    }

    public void removeMappingRuleConfiguration(HttpMappingRule mappingRuleConfiguration) {
        this.mappingRuleConfigurations.remove(mappingRuleConfiguration);
    }

    public Map<String, MappedServices> getMappedServices() {
        HashMap<String, MappedServices> answer = new HashMap<String, MappedServices>();
        for (HttpMappingRule mappingRuleConfiguration : this.mappingRuleConfigurations) {
            mappingRuleConfiguration.appendMappedServices(answer);
        }
        return answer;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }

    public void unsetCurator(CuratorFramework curator) {
        this.curator = null;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public void unsetFabricService(FabricService fabricService) {
        this.fabricService = null;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getReloadCommand() {
        return this.reloadCommand;
    }

    public void setReloadCommand(String reloadCommand) {
        this.reloadCommand = reloadCommand;
    }

    public String getReloadCommandDirectory() {
        return this.reloadCommandDirectory;
    }

    public void setReloadCommandDirectory(String reloadCommandDirectory) {
        this.reloadCommandDirectory = reloadCommandDirectory;
    }

    public String getTemplateText() {
        return this.templateText;
    }

    public void setTemplateText(String templateText) {
        this.templateText = templateText;
    }

    public String getGatewayVersion() {
        Version version;
        Container currentContainer;
        FabricService fabricService = this.getFabricService();
        if (fabricService != null && (currentContainer = fabricService.getCurrentContainer()) != null && (version = currentContainer.getVersion()) != null) {
            return version.getId();
        }
        return null;
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

