/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.openwire.command;

import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.ActiveMQDestination;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.Message;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.MessageId;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.support.OpenwireException;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.support.Settings;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.support.TypeConversionSupport;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.fusesource.hawtbuf.Buffer;

public class ActiveMQMessage
extends Message {
    public static final byte DATA_STRUCTURE_TYPE = 23;
    private static final Map<String, PropertySetter> JMS_PROPERTY_SETERS = new HashMap<String, PropertySetter>();

    @Override
    public byte getDataStructureType() {
        return 23;
    }

    @Override
    public Message copy() {
        ActiveMQMessage copy = new ActiveMQMessage();
        this.copy(copy);
        return copy;
    }

    protected void copy(ActiveMQMessage copy) {
        super.copy(copy);
    }

    public int hashCode() {
        MessageId id = this.getMessageId();
        if (id != null) {
            return id.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ActiveMQMessage msg = (ActiveMQMessage)o;
        MessageId oMsg = msg.getMessageId();
        MessageId thisMsg = this.getMessageId();
        return thisMsg != null && oMsg != null && oMsg.equals(thisMsg);
    }

    @Override
    public void clearBody() throws OpenwireException {
        this.setContent(null);
        this.readOnlyBody = false;
    }

    @Override
    public void clearProperties() {
        super.clearProperties();
        this.readOnlyProperties = false;
    }

    public boolean propertyExists(String name) throws OpenwireException {
        try {
            return this.getProperties().containsKey(name);
        }
        catch (IOException e) {
            throw new OpenwireException(e);
        }
    }

    public Enumeration getPropertyNames() throws OpenwireException {
        try {
            return new Vector<String>(this.getProperties().keySet()).elements();
        }
        catch (IOException e) {
            throw new OpenwireException(e);
        }
    }

    public void setObjectProperty(String name, Object value) throws OpenwireException {
        this.setObjectProperty(name, value, true);
    }

    public void setObjectProperty(String name, Object value, boolean checkReadOnly) throws OpenwireException {
        if (checkReadOnly) {
            this.checkReadOnlyProperties();
        }
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Property name cannot be empty or null");
        }
        this.checkValidObject(value);
        PropertySetter setter = JMS_PROPERTY_SETERS.get(name);
        if (setter != null && value != null) {
            setter.set(this, value);
        } else {
            try {
                this.setProperty(name, value);
            }
            catch (IOException e) {
                throw new OpenwireException(e);
            }
        }
    }

    protected void checkValidObject(Object value) throws OpenwireException {
        boolean valid = value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long;
        boolean bl = valid = valid || value instanceof Float || value instanceof Double || value instanceof Character || value instanceof String || value == null;
        if (!valid) {
            if (Settings.enable_nested_map_and_list()) {
                if (!(value instanceof Map) && !(value instanceof List)) {
                    throw new OpenwireException("Only objectified primitive objects, String, Map and List types are allowed but was: " + value + " type: " + value.getClass());
                }
            } else {
                throw new OpenwireException("Only objectified primitive objects and String types are allowed but was: " + value + " type: " + value.getClass());
            }
        }
    }

    public Object getObjectProperty(String name) throws OpenwireException {
        if (name == null) {
            throw new NullPointerException("Property name cannot be null");
        }
        throw new UnsupportedOperationException();
    }

    public boolean getBooleanProperty(String name) throws OpenwireException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            return false;
        }
        Boolean rc = (Boolean)TypeConversionSupport.convert(value, Boolean.class);
        if (rc == null) {
            throw new OpenwireException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a boolean");
        }
        return rc;
    }

    public byte getByteProperty(String name) throws OpenwireException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Byte rc = (Byte)TypeConversionSupport.convert(value, Byte.class);
        if (rc == null) {
            throw new OpenwireException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a byte");
        }
        return rc;
    }

    public short getShortProperty(String name) throws OpenwireException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Short rc = (Short)TypeConversionSupport.convert(value, Short.class);
        if (rc == null) {
            throw new OpenwireException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a short");
        }
        return rc;
    }

    public int getIntProperty(String name) throws OpenwireException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
        if (rc == null) {
            throw new OpenwireException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as an integer");
        }
        return rc;
    }

    public long getLongProperty(String name) throws OpenwireException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("property " + name + " was null");
        }
        Long rc = (Long)TypeConversionSupport.convert(value, Long.class);
        if (rc == null) {
            throw new OpenwireException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a long");
        }
        return rc;
    }

    public float getFloatProperty(String name) throws OpenwireException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        Float rc = (Float)TypeConversionSupport.convert(value, Float.class);
        if (rc == null) {
            throw new OpenwireException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a float");
        }
        return rc.floatValue();
    }

    public double getDoubleProperty(String name) throws OpenwireException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        Double rc = (Double)TypeConversionSupport.convert(value, Double.class);
        if (rc == null) {
            throw new OpenwireException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a double");
        }
        return rc;
    }

    public String getStringProperty(String name) throws OpenwireException {
        Object value = null;
        if (name.equals("JMSXUserID")) {
            value = this.getUserID();
            if (value == null) {
                value = this.getObjectProperty(name);
            }
        } else {
            value = this.getObjectProperty(name);
        }
        if (value == null) {
            return null;
        }
        String rc = (String)TypeConversionSupport.convert(value, String.class);
        if (rc == null) {
            throw new OpenwireException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a String");
        }
        return rc;
    }

    public void setBooleanProperty(String name, boolean value) throws OpenwireException {
        this.setBooleanProperty(name, value, true);
    }

    public void setBooleanProperty(String name, boolean value, boolean checkReadOnly) throws OpenwireException {
        this.setObjectProperty(name, value, checkReadOnly);
    }

    public void setByteProperty(String name, byte value) throws OpenwireException {
        this.setObjectProperty(name, value);
    }

    public void setShortProperty(String name, short value) throws OpenwireException {
        this.setObjectProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws OpenwireException {
        this.setObjectProperty(name, value);
    }

    public void setLongProperty(String name, long value) throws OpenwireException {
        this.setObjectProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws OpenwireException {
        this.setObjectProperty(name, new Float(value));
    }

    public void setDoubleProperty(String name, double value) throws OpenwireException {
        this.setObjectProperty(name, new Double(value));
    }

    public void setStringProperty(String name, String value) throws OpenwireException {
        this.setObjectProperty(name, value);
    }

    private void checkReadOnlyProperties() throws OpenwireException {
        if (this.readOnlyProperties) {
            throw new OpenwireException("Message properties are read-only");
        }
    }

    protected void checkReadOnlyBody() throws OpenwireException {
        if (this.readOnlyBody) {
            throw new OpenwireException("Message body is read-only");
        }
    }

    @Override
    public boolean isExpired() {
        long expireTime = this.getExpiration();
        return expireTime > 0L && System.currentTimeMillis() > expireTime;
    }

    public void onSend() throws OpenwireException {
        this.setReadOnlyBody(true);
        this.setReadOnlyProperties(true);
    }

    static {
        JMS_PROPERTY_SETERS.put("JMSXDeliveryCount", new PropertySetter(){

            @Override
            public void set(Message message, Object value) throws OpenwireException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    throw new OpenwireException("Property JMSXDeliveryCount cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setRedeliveryCounter(rc - 1);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSXGroupID", new PropertySetter(){

            @Override
            public void set(Message message, Object value) throws OpenwireException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new OpenwireException("Property JMSXGroupID cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setGroupID(Buffer.utf8((String)rc));
            }
        });
        JMS_PROPERTY_SETERS.put("JMSXGroupSeq", new PropertySetter(){

            @Override
            public void set(Message message, Object value) throws OpenwireException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    throw new OpenwireException("Property JMSXGroupSeq cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setGroupSequence(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSCorrelationID", new PropertySetter(){

            @Override
            public void set(Message message, Object value) throws OpenwireException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new OpenwireException("Property JMSCorrelationID cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setCorrelationId(Buffer.utf8((String)rc));
            }
        });
        JMS_PROPERTY_SETERS.put("JMSDeliveryMode", new PropertySetter(){

            @Override
            public void set(Message message, Object value) throws OpenwireException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    Boolean bool = (Boolean)TypeConversionSupport.convert(value, Boolean.class);
                    if (bool == null) {
                        throw new OpenwireException("Property JMSDeliveryMode cannot be set from a " + value.getClass().getName() + ".");
                    }
                    rc = bool != false ? 2 : 1;
                }
                message.setPersistent(rc == 2);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSExpiration", new PropertySetter(){

            @Override
            public void set(Message message, Object value) throws OpenwireException {
                Long rc = (Long)TypeConversionSupport.convert(value, Long.class);
                if (rc == null) {
                    throw new OpenwireException("Property JMSExpiration cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setExpiration(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSPriority", new PropertySetter(){

            @Override
            public void set(Message message, Object value) throws OpenwireException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    throw new OpenwireException("Property JMSPriority cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setPriority((byte)rc.intValue());
            }
        });
        JMS_PROPERTY_SETERS.put("JMSRedelivered", new PropertySetter(){

            @Override
            public void set(Message message, Object value) throws OpenwireException {
                Boolean rc = (Boolean)TypeConversionSupport.convert(value, Boolean.class);
                if (rc == null) {
                    throw new OpenwireException("Property JMSRedelivered cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setRedelivered(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSReplyTo", new PropertySetter(){

            @Override
            public void set(Message message, Object value) throws OpenwireException {
                ActiveMQDestination rc = (ActiveMQDestination)TypeConversionSupport.convert(value, ActiveMQDestination.class);
                if (rc == null) {
                    throw new OpenwireException("Property JMSReplyTo cannot be set from a " + value.getClass().getName() + ".");
                }
                ((ActiveMQMessage)message).setReplyTo(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSTimestamp", new PropertySetter(){

            @Override
            public void set(Message message, Object value) throws OpenwireException {
                Long rc = (Long)TypeConversionSupport.convert(value, Long.class);
                if (rc == null) {
                    throw new OpenwireException("Property JMSTimestamp cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setTimestamp(rc);
            }
        });
        JMS_PROPERTY_SETERS.put("JMSType", new PropertySetter(){

            @Override
            public void set(Message message, Object value) throws OpenwireException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new OpenwireException("Property JMSType cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setType(Buffer.utf8((String)rc));
            }
        });
    }

    static interface PropertySetter {
        public void set(Message var1, Object var2) throws OpenwireException;
    }
}

