/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol;

import org.vertx.java.core.buffer.Buffer;

public class Ascii {
    private final Buffer buffer;
    private final String string;
    private int hashCode;

    public Ascii(Buffer buffer) {
        this.buffer = buffer;
        this.string = Ascii.decode(buffer);
    }

    public Ascii(String string) {
        this.string = string;
        this.buffer = Ascii.encode(string);
    }

    public Buffer toBuffer() {
        return this.buffer;
    }

    public String toString() {
        return this.string;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Class<?> clazz = obj.getClass();
        if (clazz == Ascii.class) {
            return obj.toString().equals(this.toString());
        }
        if (clazz == String.class) {
            return obj.equals(this.toString());
        }
        if (clazz == Buffer.class) {
            return obj.equals(this.toBuffer());
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.toString().hashCode();
        }
        return this.hashCode;
    }

    public static Ascii ascii(String value) {
        if (value == null) {
            return null;
        }
        return new Ascii(value);
    }

    public static Ascii ascii(Buffer buffer) {
        if (buffer == null) {
            return null;
        }
        return new Ascii(buffer);
    }

    public static Buffer encode(String value) {
        int size = value.length();
        Buffer rc = new Buffer(size);
        for (int i = 0; i < size; ++i) {
            rc.appendByte((byte)(value.charAt(i) & 0xFF));
        }
        return rc;
    }

    public static String decode(Buffer value) {
        int size = value.length();
        char[] rc = new char[size];
        for (int i = 0; i < size; ++i) {
            rc[i] = (char)(value.getByte(i) & 0xFF);
        }
        return new String(rc);
    }
}

