/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.tcp;

import io.fabric8.gateway.ServiceDetails;
import io.fabric8.gateway.ServiceMap;
import io.fabric8.gateway.handlers.tcp.TcpClientRequestFacade;
import io.fabric8.gateway.loadbalancer.ClientRequestFacade;
import io.fabric8.gateway.loadbalancer.LoadBalancer;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.net.NetClient;
import org.vertx.java.core.net.NetSocket;
import org.vertx.java.core.streams.Pump;
import org.vertx.java.core.streams.ReadStream;
import org.vertx.java.core.streams.WriteStream;

public class TcpGatewayHandler
implements Handler<NetSocket> {
    private static final transient Logger LOG = LoggerFactory.getLogger(TcpGatewayHandler.class);
    private final Vertx vertx;
    private final ServiceMap serviceMap;
    private final String protocol;
    private final LoadBalancer pathLoadBalancer;
    private final LoadBalancer serviceLoadBalancer;

    public TcpGatewayHandler(Vertx vertx, ServiceMap serviceMap, String protocol, LoadBalancer pathLoadBalancer, LoadBalancer serviceLoadBalancer) {
        this.vertx = vertx;
        this.serviceMap = serviceMap;
        this.protocol = protocol;
        this.pathLoadBalancer = pathLoadBalancer;
        this.serviceLoadBalancer = serviceLoadBalancer;
    }

    public void handle(final NetSocket socket) {
        ServiceDetails serviceDetails;
        List<ServiceDetails> services;
        TcpClientRequestFacade requestFacade;
        NetClient client = null;
        List<String> paths = this.serviceMap.getPaths();
        String path = (String)this.pathLoadBalancer.choose(paths, (ClientRequestFacade)(requestFacade = new TcpClientRequestFacade(socket)));
        if (path != null && !(services = this.serviceMap.getServices(path)).isEmpty() && (serviceDetails = (ServiceDetails)this.serviceLoadBalancer.choose(services, (ClientRequestFacade)requestFacade)) != null) {
            List<String> urlStrings = serviceDetails.getServices();
            for (String urlString : urlStrings) {
                if (!Strings.notEmpty((String)urlString)) continue;
                try {
                    URI uri = new URI(urlString);
                    String urlProtocol = uri.getScheme();
                    if (!Objects.equal((Object)this.protocol, (Object)urlProtocol)) continue;
                    Handler<AsyncResult<NetSocket>> handler = new Handler<AsyncResult<NetSocket>>(){

                        public void handle(AsyncResult<NetSocket> asyncSocket) {
                            NetSocket clientSocket = (NetSocket)asyncSocket.result();
                            Pump.createPump((ReadStream)clientSocket, (WriteStream)socket).start();
                            Pump.createPump((ReadStream)socket, (WriteStream)clientSocket).start();
                        }
                    };
                    client = this.createClient(socket, uri, handler);
                    break;
                }
                catch (MalformedURLException e) {
                    LOG.warn("Failed to parse URL: " + urlString + ". " + e, (Throwable)e);
                }
                catch (URISyntaxException e) {
                    LOG.warn("Failed to parse URI: " + urlString + ". " + e, (Throwable)e);
                }
            }
        }
        if (client == null) {
            LOG.info("No service available for protocol " + this.protocol + " for paths " + paths);
            socket.close();
        }
    }

    protected NetClient createClient(NetSocket socket, URI url, Handler<AsyncResult<NetSocket>> handler) throws MalformedURLException {
        NetClient client = this.vertx.createNetClient();
        int port = url.getPort();
        String host = url.getHost();
        LOG.info("Connecting " + socket.remoteAddress() + " to host " + host + " port " + port + " protocol " + this.protocol);
        return client.connect(port, host, handler);
    }
}

