/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.gateway.CallDetailRecord;
import io.fabric8.gateway.handlers.http.HttpGateway;
import io.fabric8.gateway.handlers.http.MappedServices;
import io.fabric8.gateway.handlers.http.ProxyMappingDetails;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;

public class HttpGatewayHandler
implements Handler<HttpServerRequest> {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpGatewayHandler.class);
    private final Vertx vertx;
    private final HttpGateway httpGateway;
    private final ObjectMapper mapper = new ObjectMapper();
    private HttpClient client;

    public HttpGatewayHandler(Vertx vertx, HttpGateway httpGateway) {
        this.vertx = vertx;
        this.httpGateway = httpGateway;
    }

    public void handle(final HttpServerRequest request) {
        long callStart = System.nanoTime();
        String uri = request.uri();
        String uri2 = null;
        if (!uri.endsWith("/")) {
            uri2 = uri + "/";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Proxying request: " + uri);
        }
        String remaining = null;
        String prefix = null;
        String proxyServiceUrl = null;
        String reverseServiceUrl = null;
        Map<String, MappedServices> mappingRules = this.httpGateway.getMappedServices();
        try {
            if (this.isMappingIndexRequest(request)) {
                String json = this.mappingRulesToJson(mappingRules);
                HttpServerResponse response = request.response();
                response.headers().set("ContentType", "application/json");
                response.end(json);
                response.setStatusCode(200);
            } else {
                MappedServices mappedServices = null;
                URL clientURL = null;
                Set<Map.Entry<String, MappedServices>> entries = mappingRules.entrySet();
                for (Map.Entry<String, MappedServices> entry : entries) {
                    String path = entry.getKey();
                    mappedServices = entry.getValue();
                    String pathPrefix = path;
                    if (!uri.startsWith(pathPrefix) && (uri2 == null || !uri2.startsWith(pathPrefix))) continue;
                    int pathPrefixLength = pathPrefix.length();
                    remaining = pathPrefixLength < uri.length() ? uri.substring(pathPrefixLength + 1) : null;
                    proxyServiceUrl = mappedServices.chooseService(request);
                    if (proxyServiceUrl == null) continue;
                    try {
                        clientURL = new URL(proxyServiceUrl);
                        if (this.client == null) {
                            this.client = this.createClient(clientURL);
                        }
                        prefix = clientURL.getPath();
                        reverseServiceUrl = request.absoluteURI().resolve(pathPrefix).toString();
                        if (!reverseServiceUrl.endsWith("/")) break;
                        reverseServiceUrl = reverseServiceUrl.substring(0, reverseServiceUrl.length() - 1);
                        break;
                    }
                    catch (MalformedURLException e) {
                        LOG.warn("Failed to parse URL: " + proxyServiceUrl + ". " + e, (Throwable)e);
                    }
                }
                if (this.client != null) {
                    String servicePath;
                    String string = servicePath = prefix != null ? prefix : "";
                    if (servicePath.length() > 0 && !servicePath.endsWith("/")) {
                        servicePath = servicePath + "/";
                    }
                    if (remaining != null) {
                        servicePath = servicePath + remaining;
                    }
                    LOG.info("Proxying request " + uri + " to service path: " + servicePath + " on service: " + proxyServiceUrl + " reverseServiceUrl: " + reverseServiceUrl);
                    HttpClient finalClient = this.client;
                    Handler<HttpClientResponse> responseHandler = new Handler<HttpClientResponse>(){

                        public void handle(HttpClientResponse clientResponse) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Proxying response: " + clientResponse.statusCode());
                            }
                            request.response().setStatusCode(clientResponse.statusCode());
                            request.response().headers().set(clientResponse.headers());
                            request.response().setChunked(true);
                            clientResponse.dataHandler((Handler)new Handler<Buffer>(){

                                public void handle(Buffer data) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("3. Proxying response body:" + data);
                                    }
                                    request.response().write(data);
                                }
                            });
                            clientResponse.endHandler((Handler)new VoidHandler(){

                                public void handle() {
                                    request.response().end();
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("4. Response end");
                                    }
                                }
                            });
                        }
                    };
                    if (mappedServices != null) {
                        ProxyMappingDetails proxyMappingDetails = new ProxyMappingDetails(proxyServiceUrl, reverseServiceUrl, servicePath);
                        responseHandler = mappedServices.wrapResponseHandlerInPolicies(request, responseHandler, proxyMappingDetails);
                    }
                    final HttpClientRequest clientRequest = this.client.request(request.method(), servicePath, (Handler)responseHandler);
                    clientRequest.headers().set(request.headers());
                    clientRequest.setChunked(true);
                    request.dataHandler((Handler)new Handler<Buffer>(){

                        public void handle(Buffer data) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("1. Proxying request body:" + data);
                            }
                            clientRequest.write(data);
                        }
                    });
                    request.endHandler((Handler)new VoidHandler(){

                        public void handle() {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("2. end of the request");
                            }
                            clientRequest.end();
                        }
                    });
                } else {
                    LOG.info("Could not find matching proxy path for " + uri + " from paths: " + mappingRules.keySet());
                    request.response().setStatusCode(404);
                    request.response().end();
                }
            }
            CallDetailRecord cdr = new CallDetailRecord(System.nanoTime() - callStart, null);
            this.httpGateway.addCallDetailRecord(cdr);
        }
        catch (Throwable e) {
            LOG.error("Caught: " + e, e);
            CallDetailRecord cdr = new CallDetailRecord(System.nanoTime() - callStart, new Date() + ":" + e.getMessage());
            this.httpGateway.addCallDetailRecord(cdr);
            request.response().setStatusCode(404);
            StringWriter buffer = new StringWriter();
            e.printStackTrace(new PrintWriter(buffer));
            request.response().setStatusMessage("Error: " + e + "\nStack Trace: " + buffer);
            request.response().close();
        }
    }

    protected String mappingRulesToJson(Map<String, MappedServices> rules) throws IOException {
        HashMap<String, Set<String>> data = new HashMap<String, Set<String>>();
        Set<Map.Entry<String, MappedServices>> entries = rules.entrySet();
        for (Map.Entry<String, MappedServices> entry : entries) {
            String key = entry.getKey();
            MappedServices value = entry.getValue();
            Set<String> serviceUrls = value.getServiceUrls();
            data.put(key, serviceUrls);
        }
        return this.mapper.writeValueAsString(data);
    }

    protected boolean isMappingIndexRequest(HttpServerRequest request) {
        if (this.httpGateway == null || !this.httpGateway.isEnableIndex()) {
            return false;
        }
        String uri = request.uri();
        return uri == null || uri.length() == 0 || uri.equals("/");
    }

    protected HttpClient createClient(URL url) throws MalformedURLException {
        HttpClient client = this.vertx.createHttpClient();
        client.setHost(url.getHost());
        client.setPort(url.getPort());
        return client;
    }
}

