/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.http;

import io.fabric8.gateway.api.ServiceDetails;
import io.fabric8.gateway.api.handlers.http.IMappedServices;
import io.fabric8.gateway.api.handlers.http.ProxyMappingDetails;
import io.fabric8.gateway.handlers.http.HttpClientRequestFacade;
import io.fabric8.gateway.handlers.http.policy.ReverseUriPolicy;
import io.fabric8.gateway.loadbalancer.ClientRequestFacade;
import io.fabric8.gateway.loadbalancer.LoadBalancer;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.HttpServerRequest;

public class MappedServices
implements IMappedServices {
    private final ServiceDetails serviceDetails;
    private final LoadBalancer loadBalancer;
    private final boolean reverseHeaders;
    private Set<String> serviceUrls = new CopyOnWriteArraySet<String>();

    public MappedServices(String service, ServiceDetails serviceDetails, LoadBalancer loadBalancer, boolean reverseHeaders) {
        this.serviceDetails = serviceDetails;
        this.loadBalancer = loadBalancer;
        this.reverseHeaders = reverseHeaders;
        this.serviceUrls.add(service);
    }

    public String toString() {
        return "MappedServices{serviceUrls=" + this.serviceUrls + '}';
    }

    public String chooseService(HttpServerRequest request) {
        return (String)this.loadBalancer.choose(new ArrayList<String>(this.serviceUrls), (ClientRequestFacade)new HttpClientRequestFacade(request));
    }

    public Handler<HttpClientResponse> wrapResponseHandlerInPolicies(HttpServerRequest request, Handler<HttpClientResponse> responseHandler, ProxyMappingDetails proxyMappingDetails) {
        if (this.reverseHeaders) {
            responseHandler = new ReverseUriPolicy(this, request, responseHandler, proxyMappingDetails);
        }
        return responseHandler;
    }

    public String rewriteUrl(String proxiedUrl) {
        return proxiedUrl;
    }

    public String getContainer() {
        return this.serviceDetails.getContainer();
    }

    public String getVersion() {
        return this.serviceDetails.getVersion();
    }

    public String getId() {
        return this.serviceDetails.getId();
    }

    public boolean isReverseHeaders() {
        return this.reverseHeaders;
    }

    public ServiceDetails getServiceDetails() {
        return this.serviceDetails;
    }

    public Set<String> getServiceUrls() {
        return this.serviceUrls;
    }
}

