/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.util.Iterator;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.impl.DeliveryImpl;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.SessionImpl;
import org.apache.qpid.proton.engine.impl.TransportSender;

public class SenderImpl
extends LinkImpl
implements Sender {
    private int _offered;
    private TransportSender _transportLink;

    SenderImpl(SessionImpl session, String name) {
        super(session, name);
    }

    public void offer(int credits) {
        this._offered = credits;
    }

    public int send(byte[] bytes, int offset, int length) {
        if (this.getLocalState() == EndpointState.CLOSED) {
            throw new IllegalStateException("send not allowed after the sender is closed.");
        }
        DeliveryImpl current = this.current();
        if (current == null || current.getLink() != this) {
            throw new IllegalArgumentException();
        }
        int sent = current.send(bytes, offset, length);
        if (sent > 0) {
            this.getSession().incrementOutgoingBytes(sent);
        }
        return sent;
    }

    public void abort() {
    }

    public Iterator<Delivery> unsettled() {
        return null;
    }

    @Override
    public void free() {
        this.getSession().freeSender(this);
        super.free();
    }

    @Override
    public boolean advance() {
        boolean advance;
        DeliveryImpl delivery = this.current();
        if (delivery != null) {
            delivery.setComplete();
        }
        if ((advance = super.advance()) && this._offered > 0) {
            --this._offered;
        }
        if (advance) {
            this.decrementCredit();
            delivery.addToTransportWorkList();
            this.getSession().incrementOutgoingDeliveries(1);
        }
        return advance;
    }

    boolean hasOfferedCredits() {
        return this._offered > 0;
    }

    @Override
    TransportSender getTransportLink() {
        return this._transportLink;
    }

    void setTransportLink(TransportSender transportLink) {
        this._transportLink = transportLink;
    }

    @Override
    public void setCredit(int credit) {
        super.setCredit(credit);
    }
}

