/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl.ws;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCounted;
import org.vertx.java.core.http.impl.ws.WebSocketFrame;

public class DefaultWebSocketFrame
implements WebSocketFrame,
ReferenceCounted {
    private final WebSocketFrame.FrameType type;
    private ByteBuf binaryData;

    public DefaultWebSocketFrame() {
        this(null, Unpooled.EMPTY_BUFFER);
    }

    public DefaultWebSocketFrame(WebSocketFrame.FrameType frameType) {
        this(frameType, Unpooled.EMPTY_BUFFER);
    }

    public DefaultWebSocketFrame(String textData) {
        this.type = WebSocketFrame.FrameType.TEXT;
        this.binaryData = Unpooled.copiedBuffer(textData, CharsetUtil.UTF_8);
    }

    public DefaultWebSocketFrame(WebSocketFrame.FrameType type, ByteBuf binaryData) {
        this.type = type;
        this.binaryData = Unpooled.unreleasableBuffer(binaryData);
    }

    @Override
    public WebSocketFrame.FrameType getType() {
        return this.type;
    }

    @Override
    public boolean isText() {
        return this.type == WebSocketFrame.FrameType.TEXT;
    }

    @Override
    public boolean isBinary() {
        return this.type == WebSocketFrame.FrameType.BINARY;
    }

    @Override
    public ByteBuf getBinaryData() {
        return this.binaryData;
    }

    @Override
    public String getTextData() {
        return this.getBinaryData().toString(CharsetUtil.UTF_8);
    }

    @Override
    public void setBinaryData(ByteBuf binaryData) {
        if (this.binaryData != null) {
            this.binaryData.release();
        }
        this.binaryData = binaryData;
    }

    @Override
    public void setTextData(String textData) {
        if (this.binaryData != null) {
            this.binaryData.release();
        }
        this.binaryData = Unpooled.copiedBuffer(textData, CharsetUtil.UTF_8);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(type: " + (Object)((Object)this.getType()) + ", " + "data: " + this.getBinaryData() + ')';
    }

    @Override
    public int refCnt() {
        return this.binaryData.refCnt();
    }

    @Override
    public ReferenceCounted retain() {
        return this.binaryData.retain();
    }

    @Override
    public ReferenceCounted retain(int increment) {
        return this.binaryData.retain(increment);
    }

    @Override
    public boolean release() {
        return this.binaryData.release();
    }

    @Override
    public boolean release(int decrement) {
        return this.binaryData.release(decrement);
    }
}

