/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.stomp;

import io.fabric8.gateway.SocketWrapper;
import io.fabric8.gateway.handlers.detecting.Protocol;
import io.fabric8.gateway.handlers.detecting.protocol.BufferSupport;
import io.fabric8.gateway.handlers.detecting.protocol.stomp.Constants;
import io.fabric8.gateway.handlers.detecting.protocol.stomp.StompFrame;
import io.fabric8.gateway.handlers.detecting.protocol.stomp.StompProtocolDecoder;
import io.fabric8.gateway.loadbalancer.ConnectionParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;

public class StompProtocol
implements Protocol {
    private static final transient Logger LOG = LoggerFactory.getLogger(StompProtocol.class);
    public static final int maxCommandLength = 20;
    public int maxHeaderLength = 10240;
    public int maxHeaders = 1000;
    public int maxDataLength = 0x6400000;
    private static final String[] SCHEMES = new String[]{"stomp", "stomp+nio"};

    @Override
    public String getProtocolName() {
        return "stomp";
    }

    @Override
    public String[] getProtocolSchemes() {
        return SCHEMES;
    }

    @Override
    public int getMaxIdentificationLength() {
        return 10;
    }

    @Override
    public boolean matches(Buffer header) {
        return BufferSupport.startsWith(header, 0, Constants.CONNECT.toBuffer()) || BufferSupport.startsWith(header, 0, Constants.STOMP.toBuffer());
    }

    @Override
    public void snoopConnectionParameters(final SocketWrapper socket, Buffer received, final Handler<ConnectionParameters> handler) {
        StompProtocolDecoder h = new StompProtocolDecoder(this);
        h.errorHandler(new Handler<String>(){

            @Override
            public void handle(String error) {
                LOG.info("STOMP protocol decoding error: " + error);
                socket.close();
            }
        });
        h.codecHandler(new Handler<StompFrame>(){

            @Override
            public void handle(StompFrame event) {
                if (event.action().equals(Constants.CONNECT) || event.action().equals(Constants.STOMP)) {
                    ConnectionParameters parameters = new ConnectionParameters();
                    parameters.protocolVirtualHost = event.getHeaderAsString(Constants.HOST);
                    parameters.protocolUser = event.getHeaderAsString(Constants.USERID);
                    parameters.protocolClientId = event.getHeaderAsString(Constants.CLIENT_ID);
                    handler.handle(parameters);
                } else {
                    LOG.info("Expected a CONNECT or STOMP frame");
                    socket.close();
                }
            }
        });
        socket.readStream().dataHandler(h);
        h.handle(received);
    }
}

