/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.Map;
import org.vertx.java.core.http.impl.AssembledLastHttpContent;
import org.vertx.java.core.http.impl.ws.DefaultWebSocketFrame;
import org.vertx.java.core.http.impl.ws.WebSocketFrame;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.net.impl.ConnectionBase;
import org.vertx.java.core.net.impl.VertxHandler;

public abstract class VertxHttpHandler<C extends ConnectionBase>
extends VertxHandler<C> {
    private final VertxInternal vertx;

    protected VertxHttpHandler(VertxInternal vertx, Map<Channel, C> connectionMap) {
        super(vertx, connectionMap);
        this.vertx = vertx;
    }

    private static ByteBuf safeBuffer(ByteBufHolder holder, ByteBufAllocator allocator) {
        return VertxHttpHandler.safeBuffer(holder.content(), allocator);
    }

    @Override
    protected void channelRead(C connection, DefaultContext context, ChannelHandlerContext chctx, Object msg) throws Exception {
        if (connection != null) {
            Channel ch = chctx.channel();
            if (context.isOnCorrectWorker(ch.eventLoop())) {
                try {
                    this.vertx.setContext(context);
                    this.doMessageReceived(connection, chctx, msg);
                }
                catch (Throwable t) {
                    context.reportException(t);
                }
            } else {
                context.execute(new Runnable((ConnectionBase)connection, chctx, msg, context){
                    final /* synthetic */ ConnectionBase val$connection;
                    final /* synthetic */ ChannelHandlerContext val$chctx;
                    final /* synthetic */ Object val$msg;
                    final /* synthetic */ DefaultContext val$context;
                    {
                        this.val$connection = connectionBase;
                        this.val$chctx = channelHandlerContext;
                        this.val$msg = object;
                        this.val$context = defaultContext;
                    }

                    @Override
                    public void run() {
                        try {
                            VertxHttpHandler.this.doMessageReceived(this.val$connection, this.val$chctx, this.val$msg);
                        }
                        catch (Throwable t) {
                            this.val$context.reportException(t);
                        }
                    }
                });
            }
        } else {
            try {
                this.doMessageReceived(connection, chctx, msg);
            }
            catch (Throwable t) {
                chctx.pipeline().fireExceptionCaught(t);
            }
        }
    }

    @Override
    protected Object safeObject(Object msg, ByteBufAllocator allocator) throws Exception {
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            ByteBuf buf = content.content();
            if (buf != Unpooled.EMPTY_BUFFER && buf.isDirect()) {
                ByteBuf newBuf = VertxHttpHandler.safeBuffer(content, allocator);
                if (msg instanceof LastHttpContent) {
                    LastHttpContent last = (LastHttpContent)msg;
                    return new AssembledLastHttpContent(newBuf, last.trailingHeaders());
                }
                return new DefaultHttpContent(newBuf);
            }
        } else if (msg instanceof io.netty.handler.codec.http.websocketx.WebSocketFrame) {
            ByteBuf payload = VertxHttpHandler.safeBuffer((io.netty.handler.codec.http.websocketx.WebSocketFrame)msg, allocator);
            if (msg instanceof BinaryWebSocketFrame) {
                return new DefaultWebSocketFrame(WebSocketFrame.FrameType.BINARY, payload);
            }
            if (msg instanceof CloseWebSocketFrame) {
                return new DefaultWebSocketFrame(WebSocketFrame.FrameType.CLOSE, payload);
            }
            if (msg instanceof PingWebSocketFrame) {
                return new DefaultWebSocketFrame(WebSocketFrame.FrameType.PING, payload);
            }
            if (msg instanceof PongWebSocketFrame) {
                return new DefaultWebSocketFrame(WebSocketFrame.FrameType.PONG, payload);
            }
            if (msg instanceof TextWebSocketFrame) {
                return new DefaultWebSocketFrame(WebSocketFrame.FrameType.TEXT, payload);
            }
            if (msg instanceof ContinuationWebSocketFrame) {
                return new DefaultWebSocketFrame(WebSocketFrame.FrameType.CONTINUATION, payload);
            }
            throw new IllegalStateException("Unsupported websocket msg " + msg);
        }
        return msg;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            ByteBuf buf = ((WebSocketFrame)msg).getBinaryData();
            if (buf != Unpooled.EMPTY_BUFFER) {
                buf = VertxHttpHandler.safeBuffer(buf, ctx.alloc());
            }
            switch (frame.getType()) {
                case BINARY: {
                    msg = new BinaryWebSocketFrame(buf);
                    break;
                }
                case TEXT: {
                    msg = new TextWebSocketFrame(buf);
                    break;
                }
                case CLOSE: {
                    msg = new CloseWebSocketFrame(true, 0, buf);
                    break;
                }
                case CONTINUATION: {
                    msg = new ContinuationWebSocketFrame(buf);
                    break;
                }
                case PONG: {
                    msg = new PongWebSocketFrame(buf);
                    break;
                }
                case PING: {
                    msg = new PingWebSocketFrame(buf);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported websocket msg " + msg);
                }
            }
        }
        ctx.write(msg, promise);
    }

    protected abstract void doMessageReceived(C var1, ChannelHandlerContext var2, Object var3) throws Exception;
}

