/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;

public class FutureHandler<T>
implements Handler<T> {
    CountDownLatch done = new CountDownLatch(1);
    T event;

    @Override
    public void handle(T event) {
        this.event = event;
        this.done.countDown();
    }

    T await() throws InterruptedException {
        this.done.await();
        return this.event;
    }

    T await(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.done.await(timeout, unit)) {
            return this.event;
        }
        return null;
    }

    public static <T> T result(FutureHandler<AsyncResult<T>> future) throws Exception {
        AsyncResult<T> asyncResult = future.await();
        if (asyncResult.failed()) {
            throw new Exception(asyncResult.cause());
        }
        return asyncResult.result();
    }
}

