/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting;

import io.fabric8.gateway.SocketWrapper;
import io.fabric8.gateway.handlers.detecting.DetectingGatewayProtocolHandler;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.http.ServerWebSocket;

public class DetectingGatewayWebSocketHandler
implements Handler<ServerWebSocket> {
    private static final transient Logger LOG = LoggerFactory.getLogger(DetectingGatewayWebSocketHandler.class);
    private final AtomicReference<DetectingGatewayProtocolHandler> handler = new AtomicReference();
    private String pathPrefix;

    @Override
    public void handle(ServerWebSocket socket) {
        DetectingGatewayProtocolHandler handler = this.handler.get();
        if (handler == null) {
            LOG.info("Rejecting web socket: no protocol detecting gateway deployed");
            socket.reject();
            return;
        }
        if (this.pathPrefix != null && !socket.path().startsWith(this.pathPrefix)) {
            LOG.info("Rejecting web socket: request path does not start with:" + this.pathPrefix);
            socket.reject();
            return;
        }
        LOG.info("Processing the web socket '" + socket.remoteAddress() + "' with the protocol detecting gateway");
        handler.handle(SocketWrapper.wrap(socket));
    }

    public DetectingGatewayProtocolHandler getHandler() {
        return this.handler.get();
    }

    public void setHandler(DetectingGatewayProtocolHandler value) {
        this.handler.set(value);
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }
}

