/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.kubernetes;

import io.fabric8.forge.kubernetes.AbstractPodCommand;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class PodInfo
extends AbstractPodCommand {
    String indent = "    ";
    private int indentCount = 0;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).category(Categories.create((String[])new String[]{CATEGORY})).name(CATEGORY + ": Pod Info").description("Shows detailed information for the given pod in the kubernetes cloud");
    }

    @Override
    protected void executePod(Pod podInfo, String podId) {
        PodSpec spec;
        System.out.println("Created: " + podInfo.getMetadata().getCreationTimestamp());
        System.out.println("Labels: ");
        Map labels = podInfo.getMetadata().getLabels();
        for (Map.Entry entry : labels.entrySet()) {
            System.out.println(this.indent + (String)entry.getKey() + " = " + (String)entry.getValue());
        }
        PodStatus currentState = podInfo.getStatus();
        if (currentState != null) {
            this.printValue("Host", currentState.getHostIP());
            this.printValue("IP", currentState.getPodIP());
            this.printValue("Status", KubernetesHelper.getStatusText((PodStatus)currentState));
        }
        if ((spec = podInfo.getSpec()) != null) {
            List volumes;
            List containers = spec.getContainers();
            if (PodInfo.notEmpty(containers)) {
                System.out.println("Containers:");
                ++this.indentCount;
                for (Container container : containers) {
                    List volumeMounts;
                    List envList;
                    this.printValue("Name", container.getName());
                    this.printValue("Image", container.getImage());
                    this.printValue("Working Dir", container.getWorkingDir());
                    this.printValue("Command", container.getCommand());
                    List ports = container.getPorts();
                    if (PodInfo.notEmpty(ports)) {
                        this.println("Ports:");
                        ++this.indentCount;
                        for (ContainerPort port : ports) {
                            this.printValue("Name", port.getName());
                            this.printValue("Protocol", port.getProtocol());
                            this.printValue("Host Port", port.getHostPort());
                            this.printValue("Container Port", port.getContainerPort());
                        }
                        --this.indentCount;
                    }
                    if (PodInfo.notEmpty(envList = container.getEnv())) {
                        this.println("Environment:");
                        ++this.indentCount;
                        for (EnvVar env : envList) {
                            this.printValue(env.getName(), env.getValue());
                        }
                        --this.indentCount;
                    }
                    if (!PodInfo.notEmpty(volumeMounts = container.getVolumeMounts())) continue;
                    this.println("Volume Mounts:");
                    ++this.indentCount;
                    for (VolumeMount volumeMount : volumeMounts) {
                        this.printValue("Name", volumeMount.getName());
                        this.printValue("Mount Path", volumeMount.getMountPath());
                        this.printValue("Read Only", volumeMount.getReadOnly());
                    }
                    --this.indentCount;
                }
            }
            if ((volumes = spec.getVolumes()) != null) {
                System.out.println("Volumes: ");
                for (Volume volume : volumes) {
                    System.out.println(this.indent + volume.getName());
                }
            }
        }
    }

    public static boolean notEmpty(Collection<?> ports) {
        return ports != null && !ports.isEmpty();
    }

    protected void println(String text) {
        this.println(this.indentCount, text);
    }

    protected void printValue(String name, Object value) {
        this.printValue(name, value, this.indentCount);
    }

    protected void printValue(String name, Object value, int indentCount) {
        if (value != null) {
            String text = name + ": " + value;
            this.println(indentCount, text);
        }
    }

    protected void println(int indentCount, String text) {
        for (int i = 0; i < indentCount; ++i) {
            System.out.print(this.indent);
        }
        System.out.println(text);
    }
}

