/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.kubernetes;

import io.fabric8.forge.kubernetes.AbstractKubernetesCommand;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;

public abstract class AbstractPodCommand
extends AbstractKubernetesCommand {
    @Inject
    @WithAttributes(label="Pod ID", description="The ID of the pod.", required=true)
    UIInput<String> podId;

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        this.podId.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                List items;
                ArrayList<String> list = new ArrayList<String>();
                PodList pods = AbstractPodCommand.this.getKubernetes().getPods();
                if (pods != null && (items = pods.getItems()) != null) {
                    for (Pod item : items) {
                        String id = KubernetesHelper.getName((Pod)item);
                        list.add(id);
                    }
                }
                Collections.sort(list);
                System.out.println("Completion list is " + list);
                return list;
            }
        });
        builder.add(this.podId);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        KubernetesClient kubernetes = this.getKubernetes();
        String podIdText = (String)this.podId.getValue();
        Pod podInfo = this.getKubernetes().getPod(podIdText);
        if (podInfo == null) {
            System.out.println("No pod for id: " + podIdText);
        } else {
            this.executePod(podInfo, podIdText);
        }
        return null;
    }

    protected abstract void executePod(Pod var1, String var2) throws Exception;
}

