/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.kubernetes;

import io.fabric8.forge.kubernetes.AbstractKubernetesCommand;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerManifest;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodState;
import io.fabric8.utils.Filter;
import io.fabric8.utils.TablePrinter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class PodsList
extends AbstractKubernetesCommand {
    @Inject
    @WithAttributes(name="filter", label="The text filter used to filter pods using label selectors")
    UIInput<String> filterText;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).category(Categories.create((String[])new String[]{CATEGORY})).name(CATEGORY + ": Pod List").description("Lists the pods in a kubernetes cloud");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        builder.add(this.filterText);
    }

    public Result execute(UIExecutionContext uiExecutionContext) throws Exception {
        KubernetesClient kubernetes = this.getKubernetes();
        PodList pods = kubernetes.getPods();
        KubernetesHelper.removeEmptyPods((PodList)pods);
        TablePrinter table = this.podsAsTable(pods);
        return this.tableResults(table);
    }

    protected TablePrinter podsAsTable(PodList pods) {
        TablePrinter table = new TablePrinter();
        table.columns(new String[]{"id", "image(s)", "host", "labels", "status"});
        List items = pods.getItems();
        if (items == null) {
            items = Collections.EMPTY_LIST;
        }
        Filter filter = KubernetesHelper.createPodFilter((String)((String)this.filterText.getValue()));
        for (Pod item : items) {
            ContainerManifest manifest;
            if (!filter.matches((Object)item)) continue;
            String id = KubernetesHelper.getId((Pod)item);
            PodState currentState = item.getCurrentState();
            String status = "";
            String host = "";
            if (currentState != null) {
                status = currentState.getStatus();
                host = currentState.getHost();
            }
            Map labelMap = item.getLabels();
            String labels = KubernetesHelper.toLabelsString((Map)labelMap);
            PodState desiredState = item.getDesiredState();
            if (desiredState == null || (manifest = desiredState.getManifest()) == null) continue;
            List containers = manifest.getContainers();
            for (Container container : containers) {
                String image = container.getImage();
                table.row(new String[]{id, image, host, labels, status});
                id = "";
                host = "";
                status = "";
                labels = "";
            }
        }
        return table;
    }
}

