/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.kubernetes;

import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import io.fabric8.utils.TablePrinter;
import java.io.PrintStream;
import javax.inject.Inject;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.UIProvider;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;

public abstract class AbstractKubernetesCommand
extends AbstractProjectCommand
implements UICommand {
    public static String CATEGORY = "Kubernetes";
    private KubernetesClient kubernetes;
    @Inject
    private ProjectFactory projectFactory;
    UIProvider uiProvider;
    @Inject
    @WithAttributes(name="kubernetesUrl", label="The URL where the kubernetes master is running")
    UIInput<String> kubernetesUrl;

    protected boolean isProjectRequired() {
        return false;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }

    public KubernetesClient getKubernetes() {
        if (this.kubernetes == null) {
            String kubernetesAddress = (String)this.kubernetesUrl.getValue();
            this.kubernetes = Strings.isNotBlank((String)kubernetesAddress) ? new KubernetesClient(new KubernetesFactory(kubernetesAddress)) : new KubernetesClient();
        }
        Objects.notNull((Object)this.kubernetes, (String)"kubernetes");
        return this.kubernetes;
    }

    public void setKubernetes(KubernetesClient kubernetes) {
        this.kubernetes = kubernetes;
    }

    public boolean isGUI() {
        return this.getUiProvider().isGUI();
    }

    public UIOutput getOutput() {
        UIProvider provider = this.getUiProvider();
        return provider != null ? provider.getOutput() : null;
    }

    public UIProvider getUiProvider() {
        return this.uiProvider;
    }

    public void setUiProvider(UIProvider uiProvider) {
        this.uiProvider = uiProvider;
    }

    public void initializeUI(UIBuilder uiBuilder) throws Exception {
    }

    protected Result tableResults(TablePrinter table) {
        table.print(this.getOut());
        return Results.success();
    }

    public PrintStream getOut() {
        UIOutput output = this.getOutput();
        if (output != null) {
            return output.out();
        }
        return System.out;
    }
}

