/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.kubernetes;

import io.fabric8.forge.kubernetes.AbstractKubernetesCommand;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.ControllerCurrentState;
import io.fabric8.kubernetes.api.model.ControllerDesiredState;
import io.fabric8.kubernetes.api.model.ReplicationControllerListSchema;
import io.fabric8.kubernetes.api.model.ReplicationControllerSchema;
import io.fabric8.utils.Filter;
import io.fabric8.utils.TablePrinter;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class ReplicationControllerList
extends AbstractKubernetesCommand {
    @Inject
    @WithAttributes(name="filter", label="The text filter used to filter pods using label selectors")
    UIInput<String> filterText;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).category(Categories.create((String[])new String[]{CATEGORY})).name(CATEGORY + ": Replication Controller List").description("Lists the replication controllers in a kubernetes cloud");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        builder.add(this.filterText);
    }

    public Result execute(UIExecutionContext uiExecutionContext) throws Exception {
        KubernetesClient kubernetes = this.getKubernetes();
        ReplicationControllerListSchema replicationControllers = kubernetes.getReplicationControllers();
        this.printReplicationControllers(replicationControllers, System.out);
        return null;
    }

    private void printReplicationControllers(ReplicationControllerListSchema replicationControllers, PrintStream out) {
        TablePrinter table = new TablePrinter();
        table.columns(new String[]{"id", "labels", "replicas", "replica selector"});
        List items = replicationControllers.getItems();
        if (items == null) {
            items = Collections.EMPTY_LIST;
        }
        Filter filter = KubernetesHelper.createReplicationControllerFilter((String)((String)this.filterText.getValue()));
        for (ReplicationControllerSchema item : items) {
            if (!filter.matches((Object)item)) continue;
            String id = item.getId();
            String labels = KubernetesHelper.toLabelsString((Map)item.getLabels());
            Integer replicas = null;
            ControllerDesiredState desiredState = item.getDesiredState();
            ControllerCurrentState currentState = item.getCurrentState();
            String selector = null;
            if (desiredState != null) {
                selector = KubernetesHelper.toLabelsString((Map)desiredState.getReplicaSelector());
            }
            if (currentState != null) {
                replicas = currentState.getReplicas();
            }
            table.row(new String[]{id, labels, KubernetesHelper.toPositiveNonZeroText((Integer)replicas), selector});
        }
        table.print();
    }
}

