/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.CamelProjectHelper;
import io.fabric8.forge.addon.utils.VersionHelper;
import io.fabric8.forge.camel.commands.project.CamelDeleteNodeXmlCommand;
import io.fabric8.forge.camel.commands.project.completer.CurrentLineCompleter;
import io.fabric8.forge.camel.commands.project.completer.RouteBuilderCompleter;
import io.fabric8.forge.camel.commands.project.completer.RouteBuilderEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.completer.SpringBootConfigurationFileCompleter;
import io.fabric8.forge.camel.commands.project.completer.XmlEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.completer.XmlFileCompleter;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.dto.ContextDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDtos;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import io.fabric8.forge.camel.commands.project.helper.CollectionHelper;
import io.fabric8.forge.camel.commands.project.helper.PoorMansLogger;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.camel.catalog.CamelCatalog;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.maven.projects.facets.MavenDependencyFacet;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.Projects;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIRegion;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.input.events.ValueChangeEvent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.w3c.dom.Element;

public abstract class AbstractCamelProjectCommand
extends AbstractProjectCommand {
    private static final PoorMansLogger LOG = new PoorMansLogger(false);
    public static String CATEGORY = "Camel";
    public static int MAX_OPTIONS = 20;
    @Inject
    protected ProjectFactory projectFactory;
    @Inject
    protected ConverterFactory converterFactory;
    @Inject
    protected CamelCatalog camelCatalog;

    protected boolean isProjectRequired() {
        return true;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelDeleteNodeXmlCommand.class).name("Camel: Delete Node XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Deletes a node from a Camel XML file");
    }

    public boolean isEnabled(UIContext context) {
        Project project;
        boolean enabled = super.isEnabled(context);
        if (!enabled) {
            return false;
        }
        if (this.requiresCamelSetup() && (project = this.getSelectedProjectOrNull(context)) != null) {
            return this.findCamelCoreDependency(project) != null;
        }
        return false;
    }

    protected Project getSelectedProjectOrNull(UIContext context) {
        return Projects.getSelectedProject((ProjectFactory)this.getProjectFactory(), (UIContext)context);
    }

    protected boolean isRunningInGui(UIContext context) {
        return context.getProvider().isGUI();
    }

    protected boolean requiresCamelSetup() {
        return true;
    }

    protected List<NodeDto> configureXmlNodes(UIContext context, Project project, String selected, UISelectOne<String> xml, UISelectOne<String> node) throws Exception {
        List<NodeDto> nodes;
        int index = 1;
        String xmlResourceName = (String)xml.getValue();
        if (Strings.isNullOrBlank((String)xmlResourceName)) {
            xmlResourceName = selected;
        }
        if (Strings.isNotBlank((String)xmlResourceName)) {
            List<ContextDto> camelContexts = CamelXmlHelper.loadCamelContext(this.camelCatalog, context, project, xmlResourceName);
            nodes = NodeDtos.toNodeList(camelContexts);
            if (camelContexts.size() == 1 && nodes.size() > 1) {
                node.setDefaultValue((Object)("1 " + nodes.get(1).getLabel()));
            }
        } else {
            nodes = Collections.EMPTY_LIST;
        }
        List<NodeDto> answer = nodes;
        ArrayList<String> choices = new ArrayList<String>();
        for (NodeDto dto : nodes) {
            choices.add(index + " " + dto.getLabel());
            ++index;
        }
        node.setValueChoices(choices);
        node.setValueConverter(s -> {
            for (int i = 0; i < answer.size(); ++i) {
                NodeDto dto = (NodeDto)answer.get(i);
                if (!dto.getKey().equals(s)) continue;
                int number = i + 1;
                return number + " " + dto.getLabel();
            }
            return s;
        });
        return answer;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }

    protected ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    protected CamelCatalog getCamelCatalog() {
        return this.camelCatalog;
    }

    protected PrintStream getOutput(UIExecutionContext context) {
        return context.getUIContext().getProvider().getOutput().out();
    }

    protected boolean isCamelProject(Project project) {
        return !this.findCamelArtifacts(project).isEmpty();
    }

    protected boolean isSpringBootProject(Project project) {
        return CamelProjectHelper.hasDependency((Project)project, (String)"org.springframework.boot");
    }

    protected Dependency findCamelCoreDependency(Project project) {
        return CamelProjectHelper.findCamelCoreDependency((Project)project);
    }

    protected Set<Dependency> findCamelArtifacts(Project project) {
        return CamelProjectHelper.findCamelArtifacts((Project)project);
    }

    protected Coordinate createCoordinate(String groupId, String artifactId, String version) {
        CoordinateBuilder builder = CoordinateBuilder.create().setGroupId(groupId).setArtifactId(artifactId);
        if (version != null) {
            builder = builder.setVersion(version);
        }
        return builder;
    }

    protected Coordinate createCamelCoordinate(String artifactId, String version) {
        return this.createCoordinate("org.apache.camel", artifactId, version);
    }

    protected RouteBuilderCompleter createRouteBuilderCompleter(Project project) {
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        return new RouteBuilderCompleter(facet);
    }

    protected RouteBuilderEndpointsCompleter createRouteBuilderEndpointsCompleter(UIContext context, Function<String, Boolean> filter) {
        Project project = this.getSelectedProject(context);
        return this.createRouteBuilderEndpointsCompleter(project, filter);
    }

    protected RouteBuilderEndpointsCompleter createRouteBuilderEndpointsCompleter(Project project, Function<String, Boolean> filter) {
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        return new RouteBuilderEndpointsCompleter(facet, filter);
    }

    protected XmlEndpointsCompleter createXmlEndpointsCompleter(UIContext context, Function<String, Boolean> filter) {
        Project project = this.getSelectedProject(context);
        return this.createXmlEndpointsCompleter(project, filter);
    }

    protected XmlEndpointsCompleter createXmlEndpointsCompleter(Project project, Function<String, Boolean> filter) {
        ResourcesFacet resourcesFacet = null;
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(ResourcesFacet.class)) {
            resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        }
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        return new XmlEndpointsCompleter(resourcesFacet, webResourcesFacet, filter);
    }

    protected XmlFileCompleter createXmlFileCompleter(Project project, Function<String, Boolean> filter) {
        ResourcesFacet resourcesFacet = null;
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(ResourcesFacet.class)) {
            resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        }
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        return new XmlFileCompleter(resourcesFacet, webResourcesFacet, filter);
    }

    protected XmlFileCompleter createXmlFileCompleter(UIContext context, Function<String, Boolean> filter) {
        Project project = this.getSelectedProject(context);
        return this.createXmlFileCompleter(project, filter);
    }

    protected SpringBootConfigurationFileCompleter createSpringBootConfigurationFileCompleter(UIContext context, Function<String, Boolean> filter) {
        Project project = this.getSelectedProject(context);
        ResourcesFacet resourcesFacet = null;
        if (project.hasFacet(ResourcesFacet.class)) {
            resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        }
        return new SpringBootConfigurationFileCompleter(resourcesFacet, filter);
    }

    protected CurrentLineCompleter createCurrentLineCompleter(int lineNumber, String file, UIContext context) throws Exception {
        Project project = this.getSelectedProject(context);
        JavaSourceFacet sourceFacet = null;
        ResourcesFacet resourcesFacet = null;
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(JavaSourceFacet.class)) {
            sourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        }
        if (project.hasFacet(ResourcesFacet.class)) {
            resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        }
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        String relativeFile = this.asRelativeFile(context, file);
        return new CurrentLineCompleter(lineNumber, relativeFile, sourceFacet, resourcesFacet, webResourcesFacet);
    }

    protected FileResource getXmlResourceFile(Project project, String xmlResourceName) {
        FileResource file;
        if (xmlResourceName == null) {
            return null;
        }
        ResourcesFacet facet = null;
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(ResourcesFacet.class)) {
            facet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        }
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        FileResource fileResource = file = facet != null ? facet.getResource(xmlResourceName) : null;
        if (file == null || !file.exists()) {
            file = webResourcesFacet != null ? webResourcesFacet.getWebResource(xmlResourceName) : null;
        }
        return file;
    }

    protected String configureXml(Project project, UISelectOne<String> xml, String currentFile) {
        String first;
        XmlFileCompleter xmlFileCompleter = this.createXmlFileCompleter(project, null);
        Set<String> files = xmlFileCompleter.getFiles();
        String answer = first = CollectionHelper.first(files);
        xml.setValueChoices(files);
        if (files.size() == 1) {
            xml.setDefaultValue((Object)first);
        } else if (currentFile != null) {
            for (String name : files) {
                if (!currentFile.endsWith(name)) continue;
                xml.setDefaultValue((Object)name);
                answer = name;
                break;
            }
        }
        return answer;
    }

    protected String configureRouteBuilder(Project project, UISelectOne<String> routeBuilders, String currentFile) {
        String first;
        RouteBuilderCompleter completer = this.createRouteBuilderCompleter(project);
        Set<String> builders = completer.getRouteBuilders();
        String answer = first = CollectionHelper.first(builders);
        routeBuilders.setValueChoices(builders);
        if (builders.size() == 1) {
            routeBuilders.setDefaultValue((Object)first);
        } else if (currentFile != null) {
            if (currentFile.endsWith(".java")) {
                currentFile = currentFile.substring(0, currentFile.length() - 5);
            }
            for (String name : builders) {
                if (!currentFile.endsWith(name)) continue;
                routeBuilders.setDefaultValue((Object)name);
                answer = name;
                break;
            }
        }
        return answer;
    }

    protected void configureComponentName(Project project, final UISelectOne<ComponentDto> componentName, boolean consumerOnly, boolean producerOnly) throws Exception {
        Iterable<ComponentDto> it = CamelCommandsHelper.createComponentDtoValues(project, this.getCamelCatalog(), null, false, consumerOnly, producerOnly, false).call();
        final LinkedHashMap<String, ComponentDto> components = new LinkedHashMap<String, ComponentDto>();
        for (ComponentDto dto : it) {
            components.put(dto.getScheme(), dto);
        }
        componentName.setValueChoices(components.values());
        componentName.setValueConverter((Converter)new Converter<String, ComponentDto>(){

            public ComponentDto convert(String text) {
                return (ComponentDto)components.get(text);
            }
        });
        componentName.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent event) {
                ComponentDto component = (ComponentDto)event.getNewValue();
                if (component != null) {
                    String description = component.getDescription();
                    componentName.setNote(description != null ? description : "");
                } else {
                    componentName.setNote("");
                }
            }
        });
    }

    protected Element getSelectedCamelElementNode(Project project, String xmlResourceName, String key) throws Exception {
        FileResource file = this.getXmlResourceFile(project, xmlResourceName);
        if (file != null) {
            InputStream resourceInputStream = file.getResourceInputStream();
            return CamelXmlHelper.getSelectedCamelElementNode(key, resourceInputStream);
        }
        return null;
    }

    protected String getSelectedFile(UIContext context) {
        String currentFile = null;
        Optional region = context.getSelection().getRegion();
        if (region.isPresent()) {
            Object resource = ((UIRegion)region.get()).getResource();
            currentFile = resource.toString();
        }
        return currentFile;
    }

    protected boolean isSelectedFileJava(UIContext context) {
        Object resource;
        Optional region = context.getSelection().getRegion();
        if (region.isPresent() && (resource = ((UIRegion)region.get()).getResource()) instanceof FileResource) {
            return ((FileResource)resource).getFullyQualifiedName().endsWith(".java");
        }
        return false;
    }

    protected boolean isSelectedFileXml(UIContext context) {
        Object resource;
        Optional region = context.getSelection().getRegion();
        if (region.isPresent() && (resource = ((UIRegion)region.get()).getResource()) instanceof FileResource) {
            return ((FileResource)resource).getFullyQualifiedName().endsWith(".xml");
        }
        return false;
    }

    protected int getCurrentCursorLine(UIContext context) {
        int answer = -1;
        Optional region = context.getSelection().getRegion();
        if (region.isPresent()) {
            answer = ((UIRegion)region.get()).getStartLine();
        }
        return answer;
    }

    protected int getCurrentCursorPosition(UIContext context) {
        int answer = -1;
        Optional region = context.getSelection().getRegion();
        if (region.isPresent()) {
            answer = ((UIRegion)region.get()).getStartPosition();
        }
        return answer;
    }

    protected String asRelativeFile(UIContext context, String currentFile) {
        Project project = this.getSelectedProject(context);
        JavaSourceFacet javaSourceFacet = null;
        ResourcesFacet resourcesFacet = null;
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(JavaSourceFacet.class)) {
            javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        }
        if (project.hasFacet(ResourcesFacet.class)) {
            resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        }
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        return AbstractCamelProjectCommand.asRelativeFile(currentFile, javaSourceFacet, resourcesFacet, webResourcesFacet);
    }

    public static String asRelativeFile(String currentFile, JavaSourceFacet javaSourceFacet, ResourcesFacet resourcesFacet, WebResourcesFacet webResourcesFacet) {
        boolean javaFile = currentFile != null && currentFile.endsWith(".java");
        String target = null;
        if (javaFile && javaSourceFacet != null) {
            String baseDir = javaSourceFacet.getSourceDirectory().getFullyQualifiedName();
            String fqn = currentFile;
            if (fqn != null && fqn.startsWith(baseDir) && fqn.length() > baseDir.length()) {
                target = fqn.substring(baseDir.length() + 1);
            }
            if (target == null) {
                baseDir = javaSourceFacet.getTestSourceDirectory().getFullyQualifiedName();
                fqn = currentFile;
                if (fqn != null && fqn.startsWith(baseDir) && fqn.length() > baseDir.length()) {
                    target = fqn.substring(baseDir.length() + 1);
                }
            }
        } else if (resourcesFacet != null || webResourcesFacet != null) {
            String fqn;
            String baseDir;
            if (resourcesFacet != null) {
                baseDir = resourcesFacet.getResourceDirectory().getFullyQualifiedName();
                fqn = currentFile;
                if (fqn != null && fqn.startsWith(baseDir) && fqn.length() > baseDir.length()) {
                    target = fqn.substring(baseDir.length() + 1);
                }
            }
            if (target == null && webResourcesFacet != null) {
                baseDir = webResourcesFacet.getWebRootDirectory().getFullyQualifiedName();
                fqn = currentFile;
                if (fqn != null && fqn.startsWith(baseDir) && fqn.length() > baseDir.length()) {
                    target = fqn.substring(baseDir.length() + 1);
                }
            }
        }
        return target != null ? target : currentFile;
    }

    protected Set<String> discoverCustomCamelComponentsOnClasspathAndAddToCatalog(CamelCatalog camelCatalog, Project project) {
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        MavenDependencyFacet facet = (MavenDependencyFacet)project.getFacet(MavenDependencyFacet.class);
        List list = facet.getEffectiveDependencies();
        for (Dependency dep : list) {
            String[] part;
            String components;
            Properties properties = AbstractCamelProjectCommand.loadComponentProperties(dep);
            if (properties == null || (components = (String)properties.get("components")) == null) continue;
            for (String scheme : part = components.split("\\s")) {
                String json;
                String javaType;
                if (camelCatalog.findComponentNames().contains(scheme) || (javaType = AbstractCamelProjectCommand.extractComponentJavaType(dep, scheme)) == null || (json = AbstractCamelProjectCommand.loadComponentJSonSchema(dep, scheme)) == null) continue;
                camelCatalog.addComponent(scheme, javaType, json);
                answer.add(scheme);
            }
        }
        return answer;
    }

    public static Properties loadComponentProperties(Dependency dependency) {
        Properties answer = new Properties();
        try {
            URL url;
            URLClassLoader child;
            InputStream is;
            File file = (File)dependency.getArtifact().getUnderlyingResourceObject();
            if (file != null && file.getName().toLowerCase().endsWith(".jar") && (is = (child = new URLClassLoader(new URL[]{url = new URL("file:" + file.getAbsolutePath())})).getResourceAsStream("META-INF/services/org/apache/camel/component.properties")) != null) {
                answer.load(is);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return answer;
    }

    public static String loadComponentJSonSchema(Dependency dependency, String scheme) {
        String answer = null;
        String path = null;
        String javaType = AbstractCamelProjectCommand.extractComponentJavaType(dependency, scheme);
        if (javaType != null) {
            int pos = javaType.lastIndexOf(".");
            path = javaType.substring(0, pos);
            path = path.replace('.', '/');
            path = path + "/" + scheme + ".json";
        }
        if (path != null) {
            try {
                URL url;
                URLClassLoader child;
                InputStream is;
                File file = (File)dependency.getArtifact().getUnderlyingResourceObject();
                if (file != null && file.getName().toLowerCase().endsWith(".jar") && (is = (child = new URLClassLoader(new URL[]{url = new URL("file:" + file.getAbsolutePath())})).getResourceAsStream(path)) != null) {
                    answer = VersionHelper.loadText((InputStream)is);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return answer;
    }

    public static String extractComponentJavaType(Dependency dependency, String scheme) {
        try {
            URL url;
            URLClassLoader child;
            InputStream is;
            File file = (File)dependency.getArtifact().getUnderlyingResourceObject();
            if (file != null && file.getName().toLowerCase().endsWith(".jar") && (is = (child = new URLClassLoader(new URL[]{url = new URL("file:" + file.getAbsolutePath())})).getResourceAsStream("META-INF/services/org/apache/camel/component/" + scheme)) != null) {
                Properties props = new Properties();
                props.load(is);
                return (String)props.get("class");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

