/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.addon.utils.CamelProjectHelper;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.PoorMansLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;

public class CamelComponentsCompleter
implements UICompleter<ComponentDto> {
    private static final PoorMansLogger LOG = new PoorMansLogger(false);
    private final Project project;
    private final CamelCatalog camelCatalog;
    private final UIInput<String> filter;
    private final boolean excludeComponentsOnClasspath;
    private final boolean includeCatalogComponents;
    private final boolean consumerOnly;
    private final boolean producerOnly;
    private final boolean mustHaveOptions;
    private final Dependency core;

    public CamelComponentsCompleter(Project project, CamelCatalog camelCatalog, UIInput<String> filter, boolean excludeComponentsOnClasspath, boolean includeCatalogComponents, boolean consumerOnly, boolean producerOnly, boolean mustHasOptions) {
        this.project = project;
        this.camelCatalog = camelCatalog;
        this.filter = filter;
        this.excludeComponentsOnClasspath = excludeComponentsOnClasspath;
        this.includeCatalogComponents = includeCatalogComponents;
        this.consumerOnly = consumerOnly;
        this.producerOnly = producerOnly;
        this.mustHaveOptions = mustHasOptions;
        this.core = CamelProjectHelper.findCamelCoreDependency((Project)project);
    }

    public Iterable<ComponentDto> getCompletionProposals(UIContext context, InputComponent input, String value) {
        if (this.core == null) {
            return null;
        }
        List<String> names = this.getComponentNames();
        List<String> filtered = new ArrayList<String>();
        for (String name : names) {
            if (value != null && !name.startsWith(value)) continue;
            filtered.add(name);
        }
        if (this.consumerOnly) {
            filtered = this.filterByConsumerOnly(filtered);
        }
        if (this.producerOnly) {
            filtered = this.filterByProducerOnly(filtered);
        }
        if (this.mustHaveOptions) {
            filtered = this.filterByMustHaveOptions(filtered);
        }
        filtered = this.filterByName(filtered);
        filtered = this.filterByLabel(filtered, (String)this.filter.getValue());
        ArrayList<ComponentDto> answer = new ArrayList<ComponentDto>();
        for (String filter : filtered) {
            ComponentDto dto = CamelCatalogHelper.createComponentDto(this.camelCatalog, filter);
            answer.add(dto);
        }
        return answer;
    }

    public Iterable<ComponentDto> getValueChoices(String label) {
        Dependency core = CamelProjectHelper.findCamelCoreDependency((Project)this.project);
        if (core == null) {
            return null;
        }
        List<String> names = this.getComponentNames();
        if (label != null && !"<all>".equals(label)) {
            names = this.filterByLabel(names, label);
        }
        if (this.consumerOnly) {
            names = this.filterByConsumerOnly(names);
        }
        if (this.producerOnly) {
            names = this.filterByProducerOnly(names);
        }
        if (this.mustHaveOptions) {
            names = this.filterByMustHaveOptions(names);
        }
        ArrayList<ComponentDto> answer = new ArrayList<ComponentDto>();
        for (String filter : names) {
            ComponentDto dto = CamelCatalogHelper.createComponentDto(this.camelCatalog, filter);
            answer.add(dto);
        }
        return answer;
    }

    public Iterable<String> getValueNames(String label) {
        Dependency core = CamelProjectHelper.findCamelCoreDependency((Project)this.project);
        if (core == null) {
            return null;
        }
        List<String> names = this.getComponentNames();
        if (label != null && !"<all>".equals(label)) {
            names = this.filterByLabel(names, label);
        }
        if (this.consumerOnly) {
            names = this.filterByConsumerOnly(names);
        }
        if (this.producerOnly) {
            names = this.filterByProducerOnly(names);
        }
        if (this.mustHaveOptions) {
            names = this.filterByMustHaveOptions(names);
        }
        return names;
    }

    protected List<String> getComponentNames() {
        ArrayList names;
        if (this.includeCatalogComponents) {
            names = this.camelCatalog.findComponentNames();
            if (this.excludeComponentsOnClasspath) {
                Set artifacts = CamelProjectHelper.findCamelArtifacts((Project)this.project);
                for (Dependency dep : artifacts) {
                    Set<String> components = CamelCatalogHelper.componentsFromArtifact(this.camelCatalog, dep.getCoordinate().getArtifactId());
                    names.removeAll(components);
                }
            }
        } else {
            Set<String> components;
            TreeSet<String> set = new TreeSet<String>();
            Set artifacts = CamelProjectHelper.findCamelArtifacts((Project)this.project);
            for (Dependency dep : artifacts) {
                components = CamelCatalogHelper.componentsFromArtifact(this.camelCatalog, dep.getCoordinate().getArtifactId());
                set.addAll(components);
            }
            artifacts = CamelProjectHelper.findCustomCamelArtifacts((Project)this.project);
            for (Dependency dep : artifacts) {
                components = CamelCatalogHelper.componentsFromArtifact(this.camelCatalog, dep.getCoordinate().getArtifactId());
                set.addAll(components);
            }
            names = new ArrayList(set);
        }
        return names;
    }

    private List<String> filterByConsumerOnly(List<String> choices) {
        ArrayList<String> answer = new ArrayList<String>();
        for (String name : choices) {
            String json = this.camelCatalog.componentJSonSchema(name);
            String producerOnly = CamelComponentsCompleter.findProducerOnly(json);
            if (producerOnly != null && "true".equals(producerOnly)) continue;
            answer.add(name);
        }
        return answer;
    }

    private List<String> filterByProducerOnly(List<String> choices) {
        ArrayList<String> answer = new ArrayList<String>();
        for (String name : choices) {
            String json = this.camelCatalog.componentJSonSchema(name);
            String consumerOnly = CamelComponentsCompleter.findConsumerOnly(json);
            if (consumerOnly != null && "true".equals(consumerOnly)) continue;
            answer.add(name);
        }
        return answer;
    }

    private List<String> filterByMustHaveOptions(List<String> choices) {
        ArrayList<String> answer = new ArrayList<String>();
        for (String name : choices) {
            String json = this.camelCatalog.componentJSonSchema(name);
            List data = JSonSchemaHelper.parseJsonSchema((String)"componentProperties", (String)json, (boolean)true);
            if (data.isEmpty()) continue;
            answer.add(name);
        }
        return answer;
    }

    private List<String> filterByName(List<String> choices) {
        ArrayList<String> answer = new ArrayList<String>();
        for (String name : choices) {
            String json;
            String artifactId;
            boolean already = false;
            if (this.excludeComponentsOnClasspath && (artifactId = CamelComponentsCompleter.findArtifactId(json = this.camelCatalog.componentJSonSchema(name))) != null) {
                already = CamelProjectHelper.hasDependency((Project)this.project, (String)"org.apache.camel", (String)artifactId);
            }
            if (already) continue;
            answer.add(name);
        }
        return answer;
    }

    private List<String> filterByLabel(List<String> choices, String label) {
        if (label == null || label.isEmpty()) {
            return choices;
        }
        ArrayList<String> answer = new ArrayList<String>();
        block0: for (String name : choices) {
            String json = this.camelCatalog.componentJSonSchema(name);
            String labels = CamelComponentsCompleter.findLabel(json);
            if (labels != null) {
                for (String target : labels.split(",")) {
                    if (!target.startsWith(label)) continue;
                    answer.add(name);
                    continue block0;
                }
                continue;
            }
            answer.addAll(choices);
        }
        return answer;
    }

    private static String findArtifactId(String json) {
        List data = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("artifactId") == null) continue;
            return (String)row.get("artifactId");
        }
        return null;
    }

    private static String findConsumerOnly(String json) {
        List data = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("consumerOnly") == null) continue;
            return (String)row.get("consumerOnly");
        }
        return null;
    }

    private static String findProducerOnly(String json) {
        List data = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("producerOnly") == null) continue;
            return (String)row.get("producerOnly");
        }
        return null;
    }

    private static String findLabel(String json) {
        List data = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("label") == null) continue;
            return (String)row.get("label");
        }
        return null;
    }
}

