/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.LineNumberHelper;
import io.fabric8.forge.addon.utils.XmlLineNumberParser;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import java.io.InputStream;
import java.util.List;
import org.apache.camel.catalog.CamelCatalog;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AddRouteFromEndpointXmlStep
extends ConfigureEndpointPropertiesStep {
    private final String routeId;

    public AddRouteFromEndpointXmlStep(ProjectFactory projectFactory, DependencyInstaller dependencyInstaller, CamelCatalog camelCatalog, String componentName, String group, List<InputComponent> allInputs, List<InputComponent> inputs, boolean last, int index, int total, String routeId) {
        super(projectFactory, dependencyInstaller, camelCatalog, componentName, group, allInputs, inputs, last, index, total);
        this.routeId = routeId;
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConfigureEndpointPropertiesStep.class).name("Camel: Add Route").category(Categories.create((String[])new String[]{CATEGORY})).description(String.format("Configure %s options (%s of %s)", this.getGroup(), this.getIndex(), this.getTotal()));
    }

    @Override
    protected Result addOrEditEndpointXml(FileResource file, String uri, String endpointUrl, String endpointInstanceName, String xml, String lineNumber, String lineNumberEnd) throws Exception {
        Document root = XmlLineNumberParser.parseXml((InputStream)file.getResourceInputStream());
        if (root != null) {
            NodeList camels = CamelXmlHelper.getCamelContextElements(root);
            if (camels != null && camels.getLength() == 1) {
                Node camel = camels.item(0);
                Node camelContext = null;
                for (int i = 0; i < camel.getChildNodes().getLength(); ++i) {
                    Node child;
                    if (CamelXmlHelper.isCamelContextOrRoutesNode(camel)) {
                        camelContext = camel;
                    }
                    if (!CamelXmlHelper.isCamelContextOrRoutesNode(child = camel.getChildNodes().item(i))) continue;
                    camelContext = child;
                }
                if (camelContext == null) {
                    return Results.fail((String)("Cannot find <camelContext> or <routes> in XML file " + xml));
                }
                lineNumber = (String)camelContext.getUserData("lineNumber");
                lineNumberEnd = (String)camelContext.getUserData("lineNumberEnd");
                if (lineNumber != null && lineNumberEnd != null) {
                    String line1 = this.routeId != null ? String.format("<route id=\"%s\">", this.routeId) : "<route>";
                    String line2 = String.format("<from uri=\"%s\"/>", uri);
                    String line3 = "</route>";
                    List lines = LineNumberHelper.readLines((InputStream)file.getResourceInputStream());
                    int idx = Integer.valueOf(lineNumberEnd) - 1;
                    int spaces = LineNumberHelper.leadingSpaces((List)lines, (int)idx);
                    line3 = LineNumberHelper.padString((String)line3, (int)(spaces + 2));
                    line2 = LineNumberHelper.padString((String)line2, (int)(spaces + 4));
                    line1 = LineNumberHelper.padString((String)line1, (int)(spaces + 2));
                    String text = (String)lines.get(idx - 1);
                    boolean emptyLine = text == null || text.trim().isEmpty();
                    lines.add(idx, "");
                    lines.add(idx, line3);
                    lines.add(idx, line2);
                    lines.add(idx, line1);
                    if (!emptyLine) {
                        lines.add(idx, "");
                    }
                    String content = LineNumberHelper.linesToString((List)lines);
                    file.setContents(content);
                }
                return Results.success((String)"Added route");
            }
            return Results.fail((String)("Cannot find Camel node in XML file: " + xml));
        }
        return Results.fail((String)"Could not load camel XML");
    }
}

