/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.roaster.model.JavaClass;

public class RouteBuilderCompleter
implements UICompleter<String> {
    private final Set<String> routeBuilders = new TreeSet<String>();
    private final Set<String> packages = new TreeSet<String>();

    public RouteBuilderCompleter(JavaSourceFacet facet) {
        facet.visitJavaSources(new JavaResourceVisitor(){

            public void visit(VisitContext context, JavaResource javaResource) {
                try {
                    JavaClass clazz;
                    String superType;
                    if (!javaResource.getName().contains("package-info") && (superType = (clazz = (JavaClass)javaResource.getJavaType()).getSuperType()) != null && RouteBuilderCompleter.this.isRouteBuilder(superType)) {
                        RouteBuilderCompleter.this.routeBuilders.add(clazz.getQualifiedName());
                        RouteBuilderCompleter.this.packages.add(clazz.getPackage());
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        });
    }

    private boolean isRouteBuilder(String superType) {
        return "org.apache.camel.builder.RouteBuilder".equals(superType) || "org.apache.camel.spring.boot.FatJarRouter".equals(superType);
    }

    public Set<String> getPackages() {
        return this.packages;
    }

    public Set<String> getRouteBuilders() {
        return this.routeBuilders;
    }

    public Iterable<String> getCompletionProposals(UIContext context, InputComponent input, String value) {
        ArrayList<String> answer = new ArrayList<String>();
        for (String name : this.routeBuilders) {
            if (value != null && !name.startsWith(value)) continue;
            answer.add(name);
        }
        return answer;
    }
}

