/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.addon.utils.CamelProjectHelper;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.catalog.CamelCatalog;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.projects.Project;

public class CamelCurrentComponentsFinder {
    private final Project project;
    private final CamelCatalog camelCatalog;

    public CamelCurrentComponentsFinder(CamelCatalog camelCatalog, Project project) {
        this.camelCatalog = camelCatalog;
        this.project = project;
    }

    public List<ComponentDto> findCurrentComponents() {
        Set<String> components;
        ArrayList<ComponentDto> answer = new ArrayList<ComponentDto>();
        Dependency core = CamelProjectHelper.findCamelCoreDependency((Project)this.project);
        if (core == null) {
            return answer;
        }
        TreeSet<String> names = new TreeSet<String>();
        Set artifacts = CamelProjectHelper.findCamelArtifacts((Project)this.project);
        for (Dependency dep : artifacts) {
            components = CamelCatalogHelper.componentsFromArtifact(this.camelCatalog, dep.getCoordinate().getArtifactId());
            names.addAll(components);
        }
        artifacts = CamelProjectHelper.findCustomCamelArtifacts((Project)this.project);
        for (Dependency dep : artifacts) {
            components = CamelCatalogHelper.componentsFromArtifact(this.camelCatalog, dep.getCoordinate().getArtifactId());
            names.addAll(components);
        }
        for (String name : names) {
            ComponentDto dto = CamelCatalogHelper.createComponentDto(this.camelCatalog, name);
            answer.add(dto);
        }
        return answer;
    }
}

