/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.completer.CamelDataFormatsCompleter;
import io.fabric8.forge.camel.commands.project.dto.DataFormatDto;
import java.util.ArrayList;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class CamelProjectAddDataFormatCommand
extends AbstractCamelProjectCommand {
    @Inject
    @WithAttributes(label="Name", required=true, description="Name of dataformat to add")
    private UISelectOne<String> dataformatName;
    private Iterable<DataFormatDto> dtos;
    @Inject
    private DependencyInstaller dependencyInstaller;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelProjectAddDataFormatCommand.class).name("Camel: Project Add DataFormat").category(Categories.create((String[])new String[]{CATEGORY})).description("Adds a Camel dataformat to your project dependencies");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)builder);
        this.dtos = new CamelDataFormatsCompleter(project, this.getCamelCatalog()).getValueChoices();
        ArrayList<String> names = new ArrayList<String>();
        for (DataFormatDto dto : this.dtos) {
            names.add(dto.getName());
        }
        this.dataformatName.setValueChoices(names);
        builder.add(this.dataformatName);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        Dependency core = this.findCamelCoreDependency(project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        String name = (String)this.dataformatName.getValue();
        DataFormatDto dto = this.findDataFormatDto(name);
        if (dto != null) {
            String version = "org.apache.camel".equals(dto.getGroupId()) ? core.getCoordinate().getVersion() : dto.getVersion();
            DependencyBuilder dependency = DependencyBuilder.create().setGroupId(dto.getGroupId()).setArtifactId(dto.getArtifactId()).setVersion(version);
            this.dependencyInstaller.install(project, (Dependency)dependency);
            return Results.success((String)("Added Camel dataformat " + dto.getName() + " (" + dto.getArtifactId() + ") to the project"));
        }
        return Results.fail((String)"Unknown Camel dataformat");
    }

    private DataFormatDto findDataFormatDto(String name) {
        for (DataFormatDto dto : this.dtos) {
            if (!dto.getName().equals(name)) continue;
            return dto;
        }
        return null;
    }
}

