/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.LineNumberHelper;
import io.fabric8.forge.addon.utils.XmlLineNumberParser;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.dto.NodeDto;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import io.fabric8.forge.camel.commands.project.helper.PoorMansLogger;
import io.fabric8.utils.Strings;
import java.io.InputStream;
import java.util.List;
import org.apache.camel.catalog.CamelCatalog;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AddFromOrToEndpointXmlStep
extends ConfigureEndpointPropertiesStep {
    private static final PoorMansLogger LOG = new PoorMansLogger(false);
    private final NodeDto parentNode;
    private final boolean isFrom;

    public AddFromOrToEndpointXmlStep(ProjectFactory projectFactory, DependencyInstaller dependencyInstaller, CamelCatalog camelCatalog, String componentName, String group, List<InputComponent> allInputs, List<InputComponent> inputs, boolean last, int index, int total, NodeDto parentNode, boolean isFrom) {
        super(projectFactory, dependencyInstaller, camelCatalog, componentName, group, allInputs, inputs, last, index, total);
        this.parentNode = parentNode;
        this.isFrom = isFrom;
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConfigureEndpointPropertiesStep.class).name("Camel: Add Endpoint").category(Categories.create((String[])new String[]{CATEGORY})).description(String.format("Configure %s options (%s of %s)", this.getGroup(), this.getIndex(), this.getTotal()));
    }

    @Override
    protected Result addOrEditEndpointXml(FileResource file, String uri, String endpointUrl, String endpointInstanceName, String xml, String lineNumber, String lineNumberEnd) throws Exception {
        String key = this.parentNode.getKey();
        if (Strings.isNullOrBlank((String)key)) {
            return Results.fail((String)("Parent node has no key! " + this.parentNode + " in file " + file.getName()));
        }
        Document root = XmlLineNumberParser.parseXml((InputStream)file.getResourceInputStream());
        if (root != null) {
            Node selectedNode = CamelXmlHelper.findCamelNodeInDocument(root, key);
            if (selectedNode != null) {
                lineNumber = (String)selectedNode.getUserData("lineNumber");
                lineNumberEnd = (String)selectedNode.getUserData("lineNumberEnd");
                LOG.info("Add endpoint at line number " + lineNumber + "-" + lineNumberEnd + " at selected node " + selectedNode.getNodeName());
                if (lineNumber != null && lineNumberEnd != null) {
                    String line = this.isFrom ? String.format("<from uri=\"%s\"/>", uri) : String.format("<to uri=\"%s\"/>", uri);
                    List lines = LineNumberHelper.readLines((InputStream)file.getResourceInputStream());
                    int idx = this.isFrom ? Integer.valueOf(lineNumber) : Integer.valueOf(lineNumberEnd);
                    int spaces = LineNumberHelper.leadingSpaces((List)lines, (int)(idx - 1));
                    if (this.isFrom) {
                        spaces += 2;
                    }
                    line = LineNumberHelper.padString((String)line, (int)spaces);
                    lines.add(idx, line);
                    String content = LineNumberHelper.linesToString((List)lines);
                    file.setContents(content);
                    return Results.success((String)("Added: " + line.trim()));
                }
            }
            return Results.fail((String)("Cannot find Camel node in XML file: " + key));
        }
        return Results.fail((String)("Cannot load Camel XML file: " + file.getName()));
    }
}

