/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Vetoed;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;

public class CamelCatalogService {
    private CamelCatalog instance;

    @Produces
    public CamelCatalog createCamelCatalog() {
        if (this.instance == null) {
            this.instance = new CachedCamelCatalog();
        }
        return this.instance;
    }

    @Vetoed
    private static class CachedCamelCatalog
    extends DefaultCamelCatalog {
        private List<String> findComponentNames;
        private List<String> findDataFormatNames;
        private List<String> findLanguageNames;
        private Map<String, String> componentJSonSchema = new HashMap<String, String>();
        private Map<String, String> dataFormatJSonSchema = new HashMap<String, String>();
        private Map<String, String> languageJSonSchema = new HashMap<String, String>();
        private Set<String> findComponentLabels;
        private Set<String> findDataFormatLabels;
        private Set<String> findLanguageLabels;

        public CachedCamelCatalog() {
            this.findComponentNames();
            this.findDataFormatNames();
            this.findLanguageNames();
            this.findComponentLabels();
            this.findDataFormatLabels();
            this.findLanguageLabels();
            for (String scheme : this.findComponentNames) {
                this.componentJSonSchema(scheme);
            }
            for (String name : this.findDataFormatNames) {
                this.dataFormatJSonSchema(name);
            }
            for (String name : this.findLanguageNames) {
                this.languageJSonSchema(name);
            }
        }

        public List<String> findComponentNames() {
            if (this.findComponentNames == null) {
                this.findComponentNames = super.findComponentNames();
            }
            return this.findComponentNames;
        }

        public List<String> findDataFormatNames() {
            if (this.findDataFormatNames == null) {
                this.findDataFormatNames = super.findDataFormatNames();
            }
            return this.findDataFormatNames;
        }

        public List<String> findLanguageNames() {
            if (this.findLanguageNames == null) {
                this.findLanguageNames = super.findLanguageNames();
            }
            return this.findLanguageNames;
        }

        public String componentJSonSchema(String name) {
            String answer = this.componentJSonSchema.get(name);
            if (answer == null) {
                answer = super.componentJSonSchema(name);
                this.componentJSonSchema.put(name, answer);
            }
            return answer;
        }

        public String dataFormatJSonSchema(String name) {
            String answer = this.dataFormatJSonSchema.get(name);
            if (answer == null) {
                answer = super.dataFormatJSonSchema(name);
                this.dataFormatJSonSchema.put(name, answer);
            }
            return answer;
        }

        public String languageJSonSchema(String name) {
            String answer = this.languageJSonSchema.get(name);
            if (answer == null) {
                answer = super.languageJSonSchema(name);
                this.languageJSonSchema.put(name, answer);
            }
            return answer;
        }

        public Set<String> findComponentLabels() {
            if (this.findComponentLabels == null) {
                this.findComponentLabels = super.findComponentLabels();
            }
            return this.findComponentLabels;
        }

        public Set<String> findDataFormatLabels() {
            if (this.findDataFormatLabels == null) {
                this.findDataFormatLabels = super.findDataFormatLabels();
            }
            return this.findDataFormatLabels;
        }

        public Set<String> findLanguageLabels() {
            if (this.findLanguageLabels == null) {
                this.findLanguageLabels = super.findLanguageLabels();
            }
            return this.findLanguageLabels;
        }
    }
}

