/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.completer.RouteBuilderEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.completer.XmlEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import java.util.List;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class CamelValidateEndpointCommand
extends AbstractCamelProjectCommand {
    @Override
    public boolean isEnabled(UIContext context) {
        Project project = this.getSelectedProjectOrNull(context);
        return project != null;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelValidateEndpointCommand.class).name("Camel: Validate Endpoint").category(Categories.create((String[])new String[]{CATEGORY})).description("Validate Camel Endpoints in the project");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Object msg;
        String uri;
        Project project = this.getSelectedProject((UIContextProvider)context);
        Dependency core = this.findCamelCoreDependency(project);
        if (core == null) {
            return Results.success((String)"Cannot find Apache Camel");
        }
        ResourcesFacet resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        XmlEndpointsCompleter xmlEndpointCompleter = new XmlEndpointsCompleter(resourcesFacet, webResourcesFacet);
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        RouteBuilderEndpointsCompleter javaEndpointsCompleter = new RouteBuilderEndpointsCompleter(javaSourceFacet);
        List<CamelEndpointDetails> javaEndpoints = javaEndpointsCompleter.getEndpoints();
        List<CamelEndpointDetails> xmlEndpoints = xmlEndpointCompleter.getEndpoints();
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (CamelEndpointDetails detail : javaEndpoints) {
            uri = detail.getEndpointUri();
            msg = null;
            ++count;
        }
        for (CamelEndpointDetails detail : xmlEndpoints) {
            uri = detail.getEndpointUri();
            msg = null;
            ++count;
        }
        if (sb.length() > 0) {
            return Results.fail((String)("Camel endpoint validation failed\n" + sb.toString()));
        }
        return Results.success((String)"Camel endpoint validation success");
    }
}

