/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.validator.ResourceNameValidator;
import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.CamelNewRouteBuilderCommand;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import java.io.File;
import java.util.HashMap;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.URLResource;
import org.jboss.forge.addon.templates.Template;
import org.jboss.forge.addon.templates.TemplateFactory;
import org.jboss.forge.addon.templates.freemarker.FreemarkerTemplate;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.facets.HintsFacet;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.validate.UIValidator;

@FacetConstraint(value={ResourcesFacet.class})
public class CamelNewBlueprintXmlCommand
extends AbstractCamelProjectCommand {
    @Inject
    @WithAttributes(label="Directory", required=false, defaultValue="OSGI-INF/blueprint", description="The directory name where this type will be created")
    private UIInput<String> directory;
    @Inject
    @WithAttributes(label="File Name", required=true, description="Name of XML file")
    private UIInput<String> name;
    @Inject
    private DependencyInstaller dependencyInstaller;
    @Inject
    private TemplateFactory factory;
    @Inject
    ResourceFactory resourceFactory;

    @Override
    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            Project project = this.getSelectedProject(context);
            boolean cdi = CamelCommandsHelper.isCdiProject(project);
            boolean spring = CamelCommandsHelper.isSpringProject(project);
            return !cdi && !spring;
        }
        return false;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelNewRouteBuilderCommand.class).name("Camel: New XML blueprint").category(Categories.create((String[])new String[]{CATEGORY})).description("Creates a new Blueprint XML file with CamelContext");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        ((HintsFacet)this.directory.getFacet(HintsFacet.class)).setInputType("org.jboss.forge.inputType.DIRECTORY_PICKER");
        this.name.addValidator((UIValidator)new ResourceNameValidator("xml"));
        ((HintsFacet)this.name.getFacet(HintsFacet.class)).setInputType("org.jboss.forge.inputType.FILE_PICKER");
        builder.add(this.directory).add(this.name);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        String projectName = project.getRoot().getName();
        String fileName = this.directory.getValue() != null ? (String)this.directory.getValue() + File.separator + (String)this.name.getValue() : (String)this.name.getValue();
        String fullName = "src" + File.separator + "main" + File.separator + "resources" + File.separator + fileName;
        ResourcesFacet facet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        FileResource fileResource = facet.getResource(fileName);
        if (fileResource.exists()) {
            return Results.fail((String)("Blueprint XML file " + fullName + " already exists"));
        }
        Dependency core = this.findCamelCoreDependency(project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        DependencyBuilder spring = DependencyBuilder.create().setGroupId("org.apache.camel").setArtifactId("camel-blueprint").setVersion(core.getCoordinate().getVersion());
        if (!this.dependencyInstaller.isManaged(project, (Dependency)spring)) {
            this.dependencyInstaller.install(project, (Dependency)spring);
        }
        Resource xml = this.resourceFactory.create((Object)((Object)((Object)this)).getClass().getResource("/templates/camel-blueprint.ftl")).reify(URLResource.class);
        Template template = this.factory.create(xml, FreemarkerTemplate.class);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("projectName", projectName);
        String output = template.process(params);
        fileResource.createNewFile();
        fileResource.setContents(output);
        return Results.success((String)("Created new Blueprint XML file " + fullName));
    }
}

