/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ExpressionStatement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodInvocation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SimpleName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.StringLiteral;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class CamelJavaParserHelper {
    public static MethodSource<JavaClassSource> findConfigureMethod(JavaClassSource clazz) {
        MethodSource method = clazz.getMethod("configure");
        if (method != null && method.isPublic() && method.getParameters().isEmpty() && method.getReturnType().isType("void")) {
            return method;
        }
        return null;
    }

    public static List<String> parseCamelConsumerUris(MethodSource<JavaClassSource> method, boolean strings, boolean fields) {
        return CamelJavaParserHelper.parseCamelUris(method, true, false, strings, fields);
    }

    public static List<String> parseCamelProducerUris(MethodSource<JavaClassSource> method, boolean strings, boolean fields) {
        return CamelJavaParserHelper.parseCamelUris(method, false, true, strings, fields);
    }

    private static List<String> parseCamelUris(MethodSource<JavaClassSource> method, boolean consumers, boolean producers, boolean strings, boolean fields) {
        ArrayList<String> answer = new ArrayList<String>();
        MethodDeclaration md = (MethodDeclaration)method.getInternal();
        for (Object statement : md.getBody().statements()) {
            if (!(statement instanceof ExpressionStatement)) continue;
            ExpressionStatement es = (ExpressionStatement)statement;
            Expression exp = es.getExpression();
            ArrayList<String> uris = new ArrayList<String>();
            CamelJavaParserHelper.parseExpression(method, exp, uris, consumers, producers, strings, fields);
            if (uris.isEmpty()) continue;
            Collections.reverse(uris);
            answer.addAll(uris);
        }
        return answer;
    }

    private static void parseExpression(MethodSource<JavaClassSource> method, Expression exp, List<String> uris, boolean consumers, boolean producers, boolean strings, boolean fields) {
        if (exp == null) {
            return;
        }
        if (exp instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)exp;
            CamelJavaParserHelper.parseCamelUris(method, mi, uris, consumers, producers, strings, fields);
            exp = mi.getExpression();
            CamelJavaParserHelper.parseExpression(method, exp, uris, consumers, producers, strings, fields);
        }
    }

    private static void parseCamelUris(MethodSource<JavaClassSource> method, MethodInvocation mi, List<String> uris, boolean consumers, boolean producers, boolean strings, boolean fields) {
        Iterator arg;
        List args;
        String name = mi.getName().getIdentifier();
        if (consumers) {
            if ("from".equals(name) && (args = mi.arguments()) != null) {
                for (Object arg2 : args) {
                    CamelJavaParserHelper.extractEndpointUriFromArgument(method, uris, arg2, strings, fields);
                }
            }
            if ("pollEnrich".equals(name) && (args = mi.arguments()) != null && args.size() >= 1) {
                arg = args.get(0);
                CamelJavaParserHelper.extractEndpointUriFromArgument(method, uris, arg, strings, fields);
            }
        }
        if (producers) {
            if (("to".equals(name) || "toD".equals(name)) && (args = mi.arguments()) != null) {
                for (Object arg2 : args) {
                    CamelJavaParserHelper.extractEndpointUriFromArgument(method, uris, arg2, strings, fields);
                }
            }
            if (("enrich".equals(name) || "wireTap".equals(name)) && (args = mi.arguments()) != null && args.size() >= 1) {
                arg = args.get(0);
                CamelJavaParserHelper.extractEndpointUriFromArgument(method, uris, arg, strings, fields);
            }
        }
    }

    private static void extractEndpointUriFromArgument(MethodSource<JavaClassSource> method, List<String> uris, Object arg, boolean strings, boolean fields) {
        FieldSource field;
        String fieldName;
        if (strings && arg instanceof StringLiteral) {
            String uri = ((StringLiteral)arg).getLiteralValue();
            uris.add(uri);
        } else if (fields && arg instanceof SimpleName && (fieldName = ((SimpleName)arg).getIdentifier()) != null && (field = ((JavaClassSource)method.getOrigin()).getField(fieldName)) != null) {
            String uri = null;
            AnnotationSource annotation = field.getAnnotation("org.apache.camel.cdi.Uri");
            if (annotation != null) {
                uri = annotation.getStringValue();
            }
            if ((annotation = field.getAnnotation("org.apache.camel.EndpointInject")) != null) {
                uri = annotation.getStringValue("uri");
            }
            if (uri != null) {
                uris.add(uri);
            }
        }
    }
}

