/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.jolokia;

import io.fabric8.forge.camel.commands.jolokia.AbstractJolokiaCommand;
import io.fabric8.forge.camel.commands.jolokia.CamelContextCompleter;
import io.fabric8.forge.camel.commands.jolokia.ConnectCommand;
import javax.inject.Inject;
import org.apache.camel.commands.CamelController;
import org.apache.camel.commands.EndpointStatisticCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class EndpointStatsCommand
extends AbstractJolokiaCommand {
    @Inject
    @WithAttributes(label="name", required=true, description="The name of the Camel context")
    private UIInput<String> name;
    @Inject
    @WithAttributes(label="decode", required=false, defaultValue="true", description="Whether to decode the endpoint uri so its human readable")
    private UIInput<String> decode;
    @Inject
    @WithAttributes(label="filter", required=false, description="Filter the list by in,out,static,dynamic (multiple values separated by comma)")
    private UIInput<String> filter;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConnectCommand.class).name("endpoint-stats").category(Categories.create((String[])new String[]{CATEGORY})).description("Display endpoint runtime statistics");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        this.name.setCompleter((UICompleter)new CamelContextCompleter(this.getController()));
        builder.add(this.name);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String url = this.getJolokiaUrl();
        if (url == null) {
            return Results.fail((String)"Not connected to remote jolokia agent. Use camel-connect command first");
        }
        boolean val = "true".equals(this.decode.getValue());
        String[] val2 = null;
        if (this.filter.getValue() != null) {
            String s = ((String)this.filter.getValue()).toString();
            val2 = s.split(",");
        }
        EndpointStatisticCommand command = new EndpointStatisticCommand((String)this.name.getValue(), val, val2);
        command.execute((CamelController)this.getController(), this.getOutput(context), this.getError(context));
        return Results.success();
    }
}

