/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.CamelEndpointDetails;
import io.fabric8.forge.camel.commands.project.ConfigureEditEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.completer.RouteBuilderEndpointsCompleter;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class CamelEditEndpointRouteBuilderCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    @Inject
    @WithAttributes(label="endpoints", required=true, description="The endpoints from the project")
    private UISelectOne<String> endpoints;
    @Inject
    private DependencyInstaller dependencyInstaller;
    @Inject
    private DependencyResolver dependencyResolver;
    private RouteBuilderEndpointsCompleter completer;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelEditEndpointRouteBuilderCommand.class).name("Camel: Edit Endpoint RouteBuilder").category(Categories.create((String[])new String[]{CATEGORY})).description("Edit Camel endpoint from an existing RouteBuilder");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject(builder.getUIContext());
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        this.completer = new RouteBuilderEndpointsCompleter(facet);
        this.endpoints.setValueChoices(this.completer.getEndpointUris());
        builder.add(this.endpoints);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        Map attributeMap = context.getUIContext().getAttributeMap();
        String selectedUri = (String)this.endpoints.getValue();
        CamelEndpointDetails detail = this.completer.getEndpointDetail(selectedUri);
        if (detail == null) {
            return null;
        }
        attributeMap.put("componentName", detail.getEndpointComponentName());
        attributeMap.put("instanceName", detail.getEndpointInstance());
        attributeMap.put("endpointUri", detail.getEndpointUri());
        attributeMap.put("lineNumber", detail.getLineNumber());
        attributeMap.put("routeBuilder", detail.getFileName());
        attributeMap.put("kind", "java");
        return Results.navigateTo(ConfigureEditEndpointPropertiesStep.class);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        boolean empty;
        boolean bl = empty = !this.endpoints.getValueChoices().iterator().hasNext();
        if (empty) {
            return Results.fail((String)"No Camel endpoints found");
        }
        return Results.success();
    }
}

