/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.jolokia;

import io.fabric8.forge.camel.commands.jolokia.AbstractJolokiaCommand;
import io.fabric8.forge.camel.commands.jolokia.CamelContextCompleter;
import io.fabric8.forge.camel.commands.jolokia.ConnectCommand;
import io.fabric8.forge.camel.commands.jolokia.RouteCompleter;
import javax.inject.Inject;
import org.apache.camel.commands.CamelController;
import org.apache.camel.commands.StringEscape;
import org.apache.camel.commands.jolokia.NoopStringEscape;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class RouteInfoCommand
extends AbstractJolokiaCommand {
    @Inject
    @WithAttributes(label="name", required=true, description="The name of the Camel context")
    private UIInput<String> name;
    @Inject
    @WithAttributes(label="route", required=true, description="The id of the route")
    private UIInput<String> route;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConnectCommand.class).name("camel-route-info").category(Categories.create((String[])new String[]{CATEGORY})).description("Display information about a Camel route.");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        this.name.setCompleter((UICompleter)new CamelContextCompleter(this.getController()));
        this.route.setCompleter((UICompleter)new RouteCompleter(this.getController(), this.name));
        builder.add(this.name).add(this.route);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String url = this.getJolokiaUrl();
        if (url == null) {
            return Results.fail((String)"Not connected to remote jolokia agent. Use camel-connect command first");
        }
        org.apache.camel.commands.RouteInfoCommand command = new org.apache.camel.commands.RouteInfoCommand((String)this.route.getValue(), (String)this.name.getValue());
        command.setStringEscape((StringEscape)new NoopStringEscape());
        command.execute((CamelController)this.getController(), this.getOutput(context), this.getError(context));
        return Results.success();
    }
}

