/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.helper;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.JSonSchemaHelper;

public final class CamelCatalogHelper {
    public static String endpointComponentName(String uri) {
        int idx;
        if (uri != null && (idx = uri.indexOf(":")) > 0) {
            return uri.substring(0, idx);
        }
        return null;
    }

    public static String findComponentArchetype(String name) {
        if (name == null || name.startsWith("camel-")) {
            return name;
        }
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        String json = catalog.componentJSonSchema(name);
        if (json == null) {
            return null;
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("artifactId") == null) continue;
            return (String)row.get("artifactId");
        }
        return null;
    }

    public static String findDataFormatArchetype(String name) {
        if (name == null || name.startsWith("camel-")) {
            return name;
        }
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        String json = catalog.dataFormatJSonSchema(name);
        if (json == null) {
            return null;
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"dataformat", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("artifactId") == null) continue;
            return (String)row.get("artifactId");
        }
        return null;
    }

    public static String findLanguageArchetype(String name) {
        if (name == null || name.startsWith("camel-")) {
            return name;
        }
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        String json = catalog.languageJSonSchema(name);
        if (json == null) {
            return null;
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"language", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("artifactId") == null) continue;
            return (String)row.get("artifactId");
        }
        return null;
    }

    public static Set<String> componentsFromArtifact(String artifactId) {
        TreeSet<String> answer = new TreeSet<String>();
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        for (String name : catalog.findComponentNames()) {
            String json = catalog.componentJSonSchema(name);
            if (json == null) continue;
            List data = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
            String scheme = null;
            String artifact = null;
            for (Map row : data) {
                if (row.get("artifactId") != null) {
                    artifact = (String)row.get("artifactId");
                }
                if (row.get("scheme") == null) continue;
                scheme = (String)row.get("scheme");
            }
            if (!artifactId.equals(artifact) || scheme == null) continue;
            answer.add(scheme);
        }
        return answer;
    }

    public static Set<String> dataFormatsFromArtifact(String artifactId) {
        TreeSet<String> answer = new TreeSet<String>();
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        for (String name : catalog.findDataFormatNames()) {
            String json = catalog.dataFormatJSonSchema(name);
            if (json == null) continue;
            List data = JSonSchemaHelper.parseJsonSchema((String)"dataformat", (String)json, (boolean)false);
            String df = null;
            String artifact = null;
            for (Map row : data) {
                if (row.get("artifactId") != null) {
                    artifact = (String)row.get("artifactId");
                }
                if (row.get("name") == null) continue;
                df = (String)row.get("name");
            }
            if (!artifactId.equals(artifact) || df == null) continue;
            answer.add(df);
        }
        return answer;
    }

    public static Set<String> languagesFromArtifact(String artifactId) {
        TreeSet<String> answer = new TreeSet<String>();
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        for (String name : catalog.findLanguageNames()) {
            String json = catalog.languageJSonSchema(name);
            if (json == null) continue;
            List data = JSonSchemaHelper.parseJsonSchema((String)"language", (String)json, (boolean)false);
            String lan = null;
            String artifact = null;
            for (Map row : data) {
                if (row.get("artifactId") != null) {
                    artifact = (String)row.get("artifactId");
                }
                if (row.get("name") == null) continue;
                lan = (String)row.get("name");
            }
            if (!artifactId.equals(artifact) || lan == null) continue;
            answer.add(lan);
        }
        return answer;
    }

    public static boolean isDefaultValue(String scheme, String key, String value) {
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        String json = catalog.componentJSonSchema(scheme);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + scheme);
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
        if (data != null) {
            for (Map propertyMap : data) {
                String name = (String)propertyMap.get("name");
                String defaultValue = (String)propertyMap.get("defaultValue");
                if (!key.equals(name)) continue;
                return value.equalsIgnoreCase(defaultValue);
            }
        }
        return false;
    }

    public static String getComponentDescription(String scheme) {
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        String json = catalog.componentJSonSchema(scheme);
        if (json == null) {
            return null;
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
        if (data != null) {
            for (Map propertyMap : data) {
                String description = (String)propertyMap.get("description");
                if (description == null) continue;
                return description;
            }
        }
        return null;
    }

    public static String getDataFormatDescription(String dataFormat) {
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        String json = catalog.dataFormatJSonSchema(dataFormat);
        if (json == null) {
            return null;
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"dataformat", (String)json, (boolean)false);
        if (data != null) {
            for (Map propertyMap : data) {
                String description = (String)propertyMap.get("description");
                if (description == null) continue;
                return description;
            }
        }
        return null;
    }

    public static String getLanguageDescription(String language) {
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        String json = catalog.languageJSonSchema(language);
        if (json == null) {
            return null;
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"language", (String)json, (boolean)false);
        if (data != null) {
            for (Map propertyMap : data) {
                String description = (String)propertyMap.get("description");
                if (description == null) continue;
                return description;
            }
        }
        return null;
    }
}

