/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.roaster.model.util.Strings;

public class ShowEndpointPropertiesStep
extends AbstractCamelProjectCommand
implements UIWizardStep {
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ShowEndpointPropertiesStep.class).name("Camel: Edit Endpoint XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Configure the endpoint options to use");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String json;
        Map attributeMap = context.getUIContext().getAttributeMap();
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        String camelComponentName = ShowEndpointPropertiesStep.optionalAttributeValue(attributeMap, "componentName");
        String uri = ShowEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "endpointUri");
        if (camelComponentName == null && uri != null) {
            camelComponentName = CamelCatalogHelper.endpointComponentName(uri);
        }
        if ((json = catalog.componentJSonSchema(camelComponentName)) == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + camelComponentName);
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
        Map currentValues = uri != null ? catalog.endpointProperties(uri) : Collections.EMPTY_MAP;
        PrintStream out = this.getOutput(context);
        out.println("");
        out.println("Camel Endpoint Options for " + uri);
        out.println("=========================");
        if (data != null) {
            for (Map propertyMap : data) {
                if (currentValues.get(propertyMap.get("name")) != null) {
                    if (propertyMap.get("name") != null) {
                        out.print("Name: " + (String)propertyMap.get("name"));
                    } else {
                        out.print("Name: -");
                    }
                    out.print(" ");
                    out.println("");
                    if (propertyMap.get("kind") != null) {
                        out.print("Kind: " + (String)propertyMap.get("kind"));
                    } else {
                        out.print("Kind: -");
                    }
                    out.print(" ");
                    out.println("");
                    if (propertyMap.get("type") != null) {
                        out.print("Type: " + (String)propertyMap.get("type"));
                    } else {
                        out.print("Type: -");
                    }
                    out.print(" ");
                    out.println("");
                    if (propertyMap.get("javaType") != null) {
                        out.print("Java Type: " + (String)propertyMap.get("javaType"));
                    } else {
                        out.print("Java Type: -");
                    }
                    out.print(" ");
                    out.println("");
                    if (currentValues.get(propertyMap.get("name")) != null) {
                        out.print("Current value: " + (String)currentValues.get(propertyMap.get("name")));
                    } else {
                        out.print("Current value: -");
                    }
                    out.print(" ");
                    out.println("");
                    if (propertyMap.get("description") != null) {
                        out.print("Description: " + (String)propertyMap.get("description"));
                    } else {
                        out.print("Description: -");
                    }
                    out.print(" ");
                    out.println("");
                    if (propertyMap.get("enum") != null) {
                        out.print("Enumeration: " + (String)propertyMap.get("enum"));
                    } else {
                        out.print("Enumeration: -");
                    }
                    out.print(" ");
                    out.println("");
                }
                out.println("");
            }
        }
        return Results.success();
    }

    public static String mandatoryAttributeValue(Map<Object, Object> attributeMap, String name) {
        String text;
        Object value = attributeMap.get(name);
        if (value != null && !Strings.isBlank((String)(text = value.toString()))) {
            return text;
        }
        throw new IllegalArgumentException("The attribute value '" + name + "' did not get passed on from the previous wizard page");
    }

    public static String optionalAttributeValue(Map<Object, Object> attributeMap, String name) {
        String text;
        Object value = attributeMap.get(name);
        if (value != null && !Strings.isBlank((String)(text = value.toString()))) {
            return text;
        }
        return null;
    }
}

