/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.VersionHelper;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Reader;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyQuery;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.addon.maven.archetype.ArchetypeCatalogFactory;
import org.jboss.forge.furnace.services.Imported;

public class FabricArchetypeCatalogFactory
implements ArchetypeCatalogFactory {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final String NAME = "fabric8";
    @Inject
    Imported<DependencyResolver> resolver;
    private ArchetypeCatalog cachedArchetypes;

    public String toString() {
        return NAME;
    }

    public String getName() {
        return NAME;
    }

    public ArchetypeCatalog getArchetypeCatalog() {
        if (this.cachedArchetypes == null) {
            String version = VersionHelper.fabric8ArchetypesVersion();
            CoordinateBuilder coordinate = CoordinateBuilder.create().setGroupId("io.fabric8.archetypes").setArtifactId("archetypes-catalog").setVersion(version).setPackaging("jar");
            Dependency dependency = ((DependencyResolver)this.resolver.get()).resolveArtifact((DependencyQuery)DependencyQueryBuilder.create((Coordinate)coordinate));
            if (dependency != null) {
                try {
                    String name = dependency.getArtifact().getFullyQualifiedName();
                    URL url = new URL("file", null, name);
                    URLClassLoader loader = new URLClassLoader(new URL[]{url});
                    InputStream is = loader.getResourceAsStream("archetype-catalog.xml");
                    if (is != null) {
                        this.cachedArchetypes = new ArchetypeCatalogXpp3Reader().read(is);
                    }
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Error while retrieving archetypes", e);
                }
            }
        }
        return this.cachedArchetypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FabricArchetypeCatalogFactory that = (FabricArchetypeCatalogFactory)o;
        return NAME.equals(NAME);
    }

    public int hashCode() {
        return NAME.hashCode();
    }
}

