/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.maven.model.Model;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

@FacetConstraint(value={MavenFacet.class})
public class CamelKubernetesServiceSetupCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    @Inject
    @WithAttributes(label="serviceName", required=false, description="The service name")
    private UIInput<String> serviceName;
    @Inject
    @WithAttributes(label="servicePort", required=false, description="The service port")
    private UIInput<String> servicePort;
    @Inject
    @WithAttributes(label="containerPort", required=false, description="The service port used by container")
    private UIInput<String> containerPort;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelKubernetesServiceSetupCommand.class).name("Camel: Kubernetes Service").category(Categories.create((String[])new String[]{CATEGORY})).description("Add/Update Kubernetes service");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        Project project = this.getSelectedProjectOrNull(context);
        return project != null;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        MavenFacet maven = (MavenFacet)project.getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        Properties properties = pom.getProperties();
        boolean updated = false;
        if (this.serviceName.getValue() != null) {
            properties.put("fabric8.service.name", this.serviceName.getValue());
            updated = true;
        }
        if (this.servicePort.getValue() != null) {
            properties.put("fabric8.service.port", this.servicePort.getValue());
            updated = true;
        }
        if (this.containerPort.getValue() != null) {
            properties.put("fabric8.service.containerPort", this.containerPort.getValue());
            updated = true;
        }
        if (updated) {
            maven.setModel(pom);
        }
        return Results.success((String)"Adding/Updating Kubernetes service");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.serviceName.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return null;
            }
        });
        this.servicePort.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return null;
            }
        });
        this.containerPort.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return null;
            }
        });
        builder.add(this.serviceName).add(this.servicePort).add(this.containerPort);
    }

    public NavigationResult next(UINavigationContext arg0) throws Exception {
        return null;
    }
}

