/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.addon.utils.LineNumberHelper;
import io.fabric8.forge.camel.commands.project.helper.PoorMansLogger;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;

public class CurrentLineCompleter
implements UICompleter<String> {
    private static final PoorMansLogger LOG = new PoorMansLogger(false);
    private final int lineNumber;
    private final String relativeFile;
    private final JavaSourceFacet sourceFacet;
    private final ResourcesFacet resourcesFacet;
    private final WebResourcesFacet webFacet;
    private final String line;

    public CurrentLineCompleter(int lineNumber, String relativeFile, JavaSourceFacet sourceFacet, ResourcesFacet resourcesFacet, WebResourcesFacet webFacet) throws Exception {
        this.lineNumber = lineNumber;
        this.relativeFile = relativeFile;
        this.sourceFacet = sourceFacet;
        this.resourcesFacet = resourcesFacet;
        this.webFacet = webFacet;
        this.line = this.getCurrentCursorLineText();
        LOG.info("Created CurrentLineCompleter[lineNumber=" + lineNumber + ",relativeFile=" + relativeFile + ",line=" + this.line + "]");
    }

    public CamelEndpointDetails getEndpoint() {
        if (this.line != null) {
            String uri = this.getCamelEndpointUri(this.line);
            String component = this.getEndpointComponentName(uri);
            if (uri != null && component != null) {
                CamelEndpointDetails details = new CamelEndpointDetails();
                details.setLineNumber("" + this.lineNumber);
                details.setLineNumberEnd("" + this.lineNumber);
                details.setEndpointUri(uri);
                details.setEndpointComponentName(component);
                details.setFileName(this.relativeFile);
                LOG.info("CurrentLineCompleter uri: " + details.getEndpointUri());
                return details;
            }
        }
        return null;
    }

    public Iterable<String> getCompletionProposals(UIContext uiContext, InputComponent<?, String> inputComponent, String value) {
        ArrayList<String> answer = new ArrayList<String>();
        if (this.line != null && (value == null || this.line.startsWith(value))) {
            answer.add(this.line);
        }
        return answer;
    }

    protected String getCurrentCursorLineText() throws Exception {
        JavaResource file;
        LOG.info("Loading relative file: " + this.relativeFile + " using java source facet: " + this.sourceFacet);
        JavaResource javaResource = file = this.sourceFacet != null ? this.sourceFacet.getJavaResource(this.relativeFile) : null;
        if (file == null || !file.exists()) {
            LOG.info("Loading relative file: " + this.relativeFile + " using resource facet: " + this.resourcesFacet);
            FileResource fileResource = file = this.resourcesFacet != null ? this.resourcesFacet.getResource(this.relativeFile) : null;
        }
        if (file == null || !file.exists()) {
            LOG.info("Loading relative file: " + this.relativeFile + " using web facet: " + this.webFacet);
            FileResource fileResource = file = this.webFacet != null ? this.webFacet.getWebResource(this.relativeFile) : null;
        }
        if (file != null) {
            List lines = LineNumberHelper.readLines((InputStream)file.getResourceInputStream());
            LOG.info("Read " + lines.size() + " lines from file: " + this.relativeFile);
            int idx = this.lineNumber - 1;
            String line = (String)lines.get(idx);
            return line;
        }
        return null;
    }

    protected String getCamelEndpointUri(String line) {
        boolean properties;
        String uri = line;
        boolean bl = properties = this.relativeFile.endsWith(".properties") || this.relativeFile.endsWith(".cfg");
        if (properties && line.contains("=")) {
            uri = line.substring(line.indexOf("=") + 1);
        }
        return uri != null ? uri.trim() : null;
    }

    protected String getEndpointComponentName(String uri) {
        if (uri.contains(":")) {
            return uri.substring(0, uri.indexOf(":"));
        }
        return null;
    }
}

