/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.dto;

import io.fabric8.forge.camel.commands.project.dto.NodeDtoSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NodeDto
extends NodeDtoSupport {
    private List<NodeDto> children;
    private Map<String, String> properties;

    public NodeDto() {
        this.children = new ArrayList<NodeDto>();
    }

    public NodeDto(String key, String id, String label, String pattern, String description, boolean supportOutput, List<NodeDto> children) {
        super(key, id, label, pattern, description, supportOutput);
        this.children = children;
    }

    @Override
    protected NodeDto copy() {
        NodeDto copy = new NodeDto(this.getKey(), this.getId(), this.getLabel(), this.getPattern(), this.getDescription(), this.isSupportOutput(), new ArrayList<NodeDto>(this.children));
        copy.setProperties(this.properties);
        return copy;
    }

    @Override
    public void addChild(NodeDto node) {
        this.children.add(node);
    }

    @Override
    public List<NodeDto> getChildren() {
        return this.children;
    }

    public void setChildren(List<NodeDto> children) {
        this.children = children;
    }

    public String getProperty(String name) {
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }

    public void setProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(name, value);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }
}

