/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.completer.XmlResourcesCamelEndpointsVisitor;
import io.fabric8.forge.camel.commands.project.helper.PoorMansLogger;
import io.fabric8.forge.camel.commands.project.helper.XmlRouteParser;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import java.io.InputStream;
import java.util.List;
import java.util.function.Function;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;
import org.jboss.forge.addon.resource.visit.VisitContext;

public class XmlWebResourcesCamelEndpointsVisitor
implements ResourceVisitor {
    private static final PoorMansLogger LOG = new PoorMansLogger(false);
    private final WebResourcesFacet facet;
    private final List<CamelEndpointDetails> endpoints;
    private final Function<String, Boolean> filter;

    public XmlWebResourcesCamelEndpointsVisitor(WebResourcesFacet facet, List<CamelEndpointDetails> endpoints, Function<String, Boolean> filter) {
        this.facet = facet;
        this.endpoints = endpoints;
        this.filter = filter;
    }

    public void visit(VisitContext visitContext, Resource<?> resource) {
        if (resource instanceof FileResource && ((FileResource)resource).isDirectory()) {
            return;
        }
        String name = resource.getFullyQualifiedName();
        name = AbstractCamelProjectCommand.asRelativeFile(name, null, null, this.facet);
        LOG.info("Resource name " + name);
        if (name.endsWith(".xml")) {
            boolean camel;
            boolean include = true;
            if (this.filter != null) {
                Boolean out = this.filter.apply(name);
                LOG.info("Filter " + name + " -> " + out);
                boolean bl = include = out == null || out != false;
            }
            if (include && (camel = XmlResourcesCamelEndpointsVisitor.containsCamelRoutes(resource))) {
                try {
                    InputStream is = resource.getResourceInputStream();
                    String fqn = resource.getFullyQualifiedName();
                    String baseDir = this.facet.getWebRootDirectory().getFullyQualifiedName();
                    XmlRouteParser.parseXmlRouteEndpoints(is, baseDir, fqn, this.endpoints);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

