/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.EditNodeXmlStep;
import io.fabric8.forge.camel.commands.project.completer.XmlEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.dto.NodeDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import io.fabric8.forge.camel.commands.project.helper.PoorMansLogger;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import io.fabric8.forge.camel.commands.project.model.InputOptionByGroup;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.IntrospectionSupport;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CamelEditNodeXmlCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    private static final PoorMansLogger LOG = new PoorMansLogger(false);
    @Inject
    @WithAttributes(label="XML File", required=true, description="The XML file to use (either Spring or Blueprint)")
    private UISelectOne<String> xml;
    @Inject
    @WithAttributes(label="Node", required=true, description="Node to edit")
    private UISelectOne<String> node;
    private transient List<NodeDto> nodes;
    private transient NodeDto preSelectedNode;
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;
    private XmlEndpointsCompleter xmlCompleter;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelEditNodeXmlCommand.class).name("Camel: Edit Node XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Edits a node in a Camel XML file");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            String currentFile;
            Project project = this.getSelectedProject(context);
            String selected = this.configureXml(project, this.xml, currentFile = this.getSelectedFile(context));
            return selected != null;
        }
        return false;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        InputStream resourceInputStream;
        Document root;
        UIContext context = builder.getUIContext();
        Map attributeMap = context.getAttributeMap();
        attributeMap.remove("navigationResult");
        Project project = this.getSelectedProject(context);
        String selectedFile = this.getSelectedFile(builder.getUIContext());
        String currentFile = this.asRelativeFile(builder.getUIContext(), selectedFile);
        int cursorLineNumber = this.getCurrentCursorLine(builder.getUIContext());
        LOG.info("Current file " + currentFile + " line number: " + cursorLineNumber);
        String selected = this.configureXml(project, this.xml, currentFile);
        this.nodes = this.configureXmlNodes(context, project, selected, this.xml, this.node);
        NodeDto candidate = null;
        FileResource file = this.getXmlResourceFile(project, currentFile);
        if (file != null && (root = CamelXmlHelper.loadCamelXmlFileAsDom(resourceInputStream = file.getResourceInputStream())) != null) {
            for (NodeDto node : this.nodes) {
                boolean skip;
                String key = node.getKey();
                Node selectedNode = CamelXmlHelper.findCamelNodeInDocument(root, key);
                LOG.info("Node " + key + " in XML " + selectedNode);
                if (selectedNode == null) continue;
                boolean bl = skip = "camelContext".equals(node.getPattern()) || "routes".equals(node.getPattern()) || "rests".equals(node.getPattern());
                if (skip) continue;
                String lineNumber = (String)selectedNode.getUserData("lineNumber");
                String lineNumberEnd = (String)selectedNode.getUserData("lineNumberEnd");
                if (lineNumber == null || lineNumberEnd == null) continue;
                LOG.info("Node " + key + " line " + lineNumber + "-" + lineNumberEnd);
                int start = Integer.parseInt(lineNumber);
                int end = Integer.parseInt(lineNumberEnd);
                if (start > cursorLineNumber || end < cursorLineNumber) continue;
                LOG.info("Selecting candidate " + node);
                candidate = node;
            }
        }
        if (candidate != null) {
            this.preSelectedNode = candidate;
        } else {
            builder.add(this.xml).add(this.node);
        }
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        NavigationResult navigationResult;
        int selectedIdx;
        Map attributeMap = context.getUIContext().getAttributeMap();
        String xmlResourceName = (String)this.xml.getValue();
        attributeMap.put("xml", xmlResourceName);
        attributeMap.put("mode", "edit");
        attributeMap.put("kind", "xml");
        NodeDto editNode = this.preSelectedNode;
        if (editNode == null && this.node != null && (selectedIdx = this.node.getSelectedIndex()) != -1) {
            editNode = this.nodes.get(selectedIdx);
        }
        String key = editNode != null ? editNode.getKey() : null;
        String previous = this.getNodeKey(attributeMap.get("node"));
        if (previous != null && previous.equals(key) && (navigationResult = (NavigationResult)attributeMap.get("navigationResult")) != null) {
            return navigationResult;
        }
        LOG.info("Edit node " + editNode + " pattern " + editNode.getPattern());
        attributeMap.put("node", key);
        String nodeName = editNode.getPattern();
        attributeMap.put("nodeName", nodeName);
        attributeMap.put("pattern", editNode.getPattern());
        if ("from".equals(editNode.getPattern()) || "to".equals(editNode.getPattern())) {
            return this.nextEditEndpoint(context, xmlResourceName, key, editNode);
        }
        return this.nextEditEip(context, xmlResourceName, key, editNode, nodeName);
    }

    private NavigationResult nextEditEndpoint(UINavigationContext context, String xmlResourceName, String key, NodeDto editNode) throws Exception {
        Map attributeMap = context.getUIContext().getAttributeMap();
        this.xmlCompleter = this.createXmlEndpointsCompleter(context.getUIContext(), xmlResourceName::equals);
        String uri = editNode.getProperty("uri");
        LOG.info("Endpoint uri " + uri);
        CamelEndpointDetails detail = this.xmlCompleter.getEndpointDetail(uri);
        LOG.info("Endpoint detail " + detail);
        if (detail == null) {
            return null;
        }
        attributeMap.put("componentName", detail.getEndpointComponentName());
        attributeMap.put("instanceName", detail.getEndpointInstance());
        attributeMap.put("endpointUri", detail.getEndpointUri());
        attributeMap.put("lineNumber", detail.getLineNumber());
        attributeMap.put("lineNumberEnd", detail.getLineNumberEnd());
        attributeMap.put("mode", "edit");
        attributeMap.put("xml", detail.getFileName());
        attributeMap.put("kind", "xml");
        String camelComponentName = detail.getEndpointComponentName();
        uri = detail.getEndpointUri();
        String json = this.getCamelCatalog().componentJSonSchema(camelComponentName);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + camelComponentName);
        }
        LOG.info("Component json: " + json);
        boolean consumerOnly = detail.isConsumerOnly();
        boolean producerOnly = detail.isProducerOnly();
        UIContext ui = context.getUIContext();
        List<InputOptionByGroup> groups = CamelCommandsHelper.createUIInputsForCamelEndpoint(camelComponentName, uri, MAX_OPTIONS, consumerOnly, producerOnly, this.getCamelCatalog(), this.componentFactory, this.converterFactory, ui);
        ArrayList<InputComponent> allInputs = new ArrayList<InputComponent>();
        for (InputOptionByGroup group : groups) {
            allInputs.addAll(group.getInputs());
        }
        LOG.info(allInputs.size() + " input fields in the UI wizard");
        NavigationResultBuilder builder = Results.navigationBuilder();
        int pages = groups.size();
        for (int i = 0; i < pages; ++i) {
            boolean last = i == pages - 1;
            InputOptionByGroup current = groups.get(i);
            ConfigureEndpointPropertiesStep step = new ConfigureEndpointPropertiesStep(this.projectFactory, this.dependencyInstaller, this.getCamelCatalog(), camelComponentName, current.getGroup(), allInputs, current.getInputs(), last, i, pages);
            builder.add((UICommand)step);
        }
        NavigationResult navigationResult = builder.build();
        attributeMap.put("navigationResult", navigationResult);
        return navigationResult;
    }

    private NavigationResult nextEditEip(UINavigationContext context, String xmlResourceName, String key, NodeDto editNode, String nodeName) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        Map attributeMap = context.getUIContext().getAttributeMap();
        Element selectedElement = this.getSelectedCamelElementNode(project, xmlResourceName, key);
        if (selectedElement == null) {
            throw new IllegalArgumentException("Cannot find xml for node " + editNode);
        }
        String lineNumber = (String)selectedElement.getUserData("lineNumber");
        String lineNumberEnd = (String)selectedElement.getUserData("lineNumberEnd");
        attributeMap.put("lineNumber", lineNumber);
        attributeMap.put("lineNumberEnd", lineNumberEnd);
        if (editNode.getChildren() != null && !editNode.getChildren().isEmpty()) {
            NodeDto child = editNode.getChildren().get(0);
            Element childElement = this.getSelectedCamelElementNode(project, xmlResourceName, child.getKey());
            String childLineNumber = (String)childElement.getUserData("lineNumber");
            if (childLineNumber != null) {
                int num = Integer.valueOf(childLineNumber) - 1;
                attributeMap.put("lineNumberEnd", "" + num);
            }
            attributeMap.put("nodeChildren", "true");
        } else {
            attributeMap.put("nodeChildren", "false");
        }
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        try {
            ClassLoader cl = CamelCatalog.class.getClassLoader();
            Object model = CamelXmlHelper.xmlAsModel(selectedElement, cl);
            LOG.info("Pojo model of node: " + model);
            LinkedHashMap temp = new LinkedHashMap();
            IntrospectionSupport.getProperties((Object)model, temp, null);
            for (Map.Entry entry : temp.entrySet()) {
                String k = (String)entry.getKey();
                Object v = entry.getValue();
                if ("outputs".equals(k)) continue;
                if (v instanceof ExpressionSubElementDefinition) {
                    ExpressionSubElementDefinition sub = (ExpressionSubElementDefinition)v;
                    ExpressionDefinition exp = sub.getExpressionType();
                    this.expressionOptions(k, exp, options);
                    continue;
                }
                if (v instanceof ExpressionDefinition) {
                    ExpressionDefinition exp = (ExpressionDefinition)v;
                    this.expressionOptions(k, exp, options);
                    continue;
                }
                String text = v != null ? v.toString() : null;
                if (text == null) continue;
                options.put(k, text);
            }
        }
        catch (Exception cl) {
            // empty catch block
        }
        LOG.info("Creating UIInputs with options: " + options);
        UIContext ui = context.getUIContext();
        List<InputOptionByGroup> groups = CamelCommandsHelper.createUIInputsForCamelEIP(nodeName, MAX_OPTIONS, options, this.getCamelCatalog(), this.componentFactory, this.converterFactory, ui);
        ArrayList<InputComponent> allInputs = new ArrayList<InputComponent>();
        for (InputOptionByGroup group : groups) {
            allInputs.addAll(group.getInputs());
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        int pages = groups.size();
        for (int i = 0; i < pages; ++i) {
            boolean last = i == pages - 1;
            InputOptionByGroup current = groups.get(i);
            EditNodeXmlStep step = new EditNodeXmlStep(this.projectFactory, this.getCamelCatalog(), nodeName, current.getGroup(), allInputs, current.getInputs(), last, i, pages);
            builder.add((UICommand)step);
        }
        NavigationResult navigationResult = builder.build();
        attributeMap.put("navigationResult", navigationResult);
        return navigationResult;
    }

    private void expressionOptions(String k, ExpressionDefinition exp, Map<String, String> options) {
        if ("completionSizeExpression".equals(k)) {
            k = "completionSize";
        } else if ("completionTimeoutExpression".equals(k)) {
            k = "completionTimeout";
        }
        String text = exp.getExpression();
        String lan = exp.getLanguage();
        options.put(k, lan);
        if (text != null) {
            options.put(k + "_value", text);
        }
        CollectionStringBuffer csb = new CollectionStringBuffer("&");
        String json = this.getCamelCatalog().languageJSonSchema(lan);
        if (json != null) {
            List data = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
            if (data != null) {
                for (Map map : data) {
                    String name = (String)map.get("name");
                    if (name == null || "id".equals(name) || "expression".equals(name)) continue;
                    try {
                        Object value = IntrospectionSupport.getProperty((Object)exp, (String)name);
                        if (value == null) continue;
                        text = value.toString();
                        csb.append((Object)(name + "=" + text));
                    }
                    catch (Exception exception) {}
                }
            }
            if (!csb.isEmpty()) {
                String extra = csb.toString();
                options.put(k + "_extra", extra);
            }
        }
    }

    private String getNodeKey(Object value) {
        if (value instanceof NodeDto) {
            NodeDto nodeDto = (NodeDto)value;
            return nodeDto.getKey();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return null;
    }
}

