/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.AddNodeXmlStep;
import io.fabric8.forge.camel.commands.project.dto.EipDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDtoSupport;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.model.InputOptionByGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.input.events.ValueChangeEvent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.w3c.dom.Element;

public class CamelAddNodeXmlCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    @Inject
    @WithAttributes(label="XML File", required=true, description="The XML file to use (either Spring or Blueprint)")
    private UISelectOne<String> xml;
    @Inject
    @WithAttributes(label="Parent Node", required=true, description="Parent node (where to add the node)")
    private UISelectOne<String> parent;
    private transient List<NodeDto> parents;
    @Inject
    @WithAttributes(label="Filter", required=false, description="To filter patterns")
    private UISelectOne<String> nameFilter;
    @Inject
    @WithAttributes(label="Pattern", required=true, description="The pattern to add")
    private UISelectOne<EipDto> name;
    @Inject
    private InputComponentFactory componentFactory;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelAddNodeXmlCommand.class).name("Camel: Add Node XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Adds a node in a Camel XML file");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            String currentFile;
            Project project = this.getSelectedProject(context);
            String selected = this.configureXml(project, this.xml, currentFile = this.getSelectedFile(context));
            return selected != null;
        }
        return false;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        UIContext context = builder.getUIContext();
        Map attributeMap = context.getAttributeMap();
        attributeMap.remove("navigationResult");
        Project project = this.getSelectedProject(context);
        String currentFile = this.getSelectedFile(context);
        String selected = this.configureXml(project, this.xml, currentFile);
        this.parents = this.configureXmlNodes(context, project, selected, this.xml, this.parent);
        this.nameFilter.setValueChoices(CamelCommandsHelper.createEipLabelValues(project, this.getCamelCatalog()));
        this.nameFilter.setDefaultValue((Object)"<all>");
        this.name.setValueChoices(CamelCommandsHelper.createAllEipDtoValues(project, this.getCamelCatalog(), this.nameFilter));
        this.name.setValueConverter((Converter)new Converter<String, EipDto>(){

            public EipDto convert(String text) {
                return CamelCatalogHelper.createEipDto(CamelAddNodeXmlCommand.this.getCamelCatalog(), text);
            }
        });
        this.name.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent event) {
                EipDto eip = (EipDto)event.getNewValue();
                if (eip != null) {
                    String description = eip.getDescription();
                    CamelAddNodeXmlCommand.this.name.setNote(description != null ? description : "");
                } else {
                    CamelAddNodeXmlCommand.this.name.setNote("");
                }
            }
        });
        builder.add(this.xml).add(this.parent).add(this.nameFilter).add(this.name);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        NavigationResult navigationResult;
        Project project = this.getSelectedProject((UIContextProvider)context);
        Map attributeMap = context.getUIContext().getAttributeMap();
        String xmlResourceName = (String)this.xml.getValue();
        attributeMap.put("xml", xmlResourceName);
        attributeMap.put("mode", "add");
        attributeMap.put("kind", "xml");
        NodeDtoSupport editNode = null;
        int selectedIdx = this.parent.getSelectedIndex();
        if (selectedIdx != -1) {
            editNode = this.parents.get(selectedIdx);
        }
        String key = editNode != null ? editNode.getKey() : null;
        String nodeName = this.name.getValue() != null ? ((EipDto)this.name.getValue()).getName() : null;
        String previous = this.getNodeKey(attributeMap.get("node"));
        String previous2 = (String)attributeMap.get("name");
        if (previous != null && previous.equals(key) && previous2 != null && previous2.equals(nodeName) && (navigationResult = (NavigationResult)attributeMap.get("navigationResult")) != null) {
            return navigationResult;
        }
        attributeMap.put("node", key);
        attributeMap.put("name", nodeName);
        attributeMap.put("pattern", editNode.getPattern());
        Element selectedElement = this.getSelectedCamelElementNode(project, xmlResourceName, key);
        if (selectedElement == null) {
            throw new IllegalArgumentException("Cannot find xml for node " + editNode);
        }
        String lineNumber = (String)selectedElement.getUserData("lineNumber");
        String lineNumberEnd = (String)selectedElement.getUserData("lineNumberEnd");
        attributeMap.put("lineNumber", lineNumber);
        attributeMap.put("lineNumberEnd", lineNumberEnd);
        UIContext ui = context.getUIContext();
        List<InputOptionByGroup> groups = CamelCommandsHelper.createUIInputsForCamelEIP(nodeName, MAX_OPTIONS, null, this.getCamelCatalog(), this.componentFactory, this.converterFactory, ui);
        ArrayList<InputComponent> allInputs = new ArrayList<InputComponent>();
        for (InputOptionByGroup group : groups) {
            allInputs.addAll(group.getInputs());
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        int pages = groups.size();
        for (int i = 0; i < pages; ++i) {
            boolean last = i == pages - 1;
            InputOptionByGroup current = groups.get(i);
            AddNodeXmlStep step = new AddNodeXmlStep(this.projectFactory, this.getCamelCatalog(), nodeName, current.getGroup(), allInputs, current.getInputs(), last, i, pages);
            builder.add((UICommand)step);
        }
        NavigationResult navigationResult2 = builder.build();
        attributeMap.put("navigationResult", navigationResult2);
        return navigationResult2;
    }

    private String getNodeKey(Object value) {
        if (value instanceof NodeDto) {
            NodeDto nodeDto = (NodeDto)value;
            return nodeDto.getKey();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return Results.success();
    }
}

