/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.CamelProjectHelper;
import io.fabric8.forge.camel.commands.project.CamelDeleteNodeXmlCommand;
import io.fabric8.forge.camel.commands.project.completer.CurrentLineCompleter;
import io.fabric8.forge.camel.commands.project.completer.RouteBuilderCompleter;
import io.fabric8.forge.camel.commands.project.completer.RouteBuilderEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.completer.XmlEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.completer.XmlFileCompleter;
import io.fabric8.forge.camel.commands.project.converter.NodeDtoConverter;
import io.fabric8.forge.camel.commands.project.converter.NodeDtoLabelConverter;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.dto.ContextDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDtos;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import io.fabric8.forge.camel.commands.project.helper.CollectionHelper;
import io.fabric8.utils.Strings;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.camel.catalog.CamelCatalog;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.Projects;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIRegion;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.input.events.ValueChangeEvent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.w3c.dom.Element;

public abstract class AbstractCamelProjectCommand
extends AbstractProjectCommand {
    public static String CATEGORY = "Camel";
    public static int MAX_OPTIONS = 20;
    @Inject
    protected ProjectFactory projectFactory;
    @Inject
    protected ConverterFactory converterFactory;
    @Inject
    protected CamelCatalog camelCatalog;

    protected void configureXmlNode(final UIContext context, final Project project, final String selected, final UISelectOne<String> xml, final UISelectOne<NodeDto> node) {
        node.setValueConverter((Converter)new NodeDtoConverter(this.camelCatalog, project, context, xml));
        node.setItemLabelConverter((Converter)new NodeDtoLabelConverter());
        node.setValueChoices((Callable)new Callable<Iterable<NodeDto>>(){

            @Override
            public Iterable<NodeDto> call() throws Exception {
                String xmlResourceName = (String)xml.getValue();
                if (Strings.isNullOrBlank((String)xmlResourceName)) {
                    xmlResourceName = selected;
                }
                List<ContextDto> camelContexts = CamelXmlHelper.loadCamelContext(AbstractCamelProjectCommand.this.camelCatalog, context, project, xmlResourceName);
                List<NodeDto> nodes = NodeDtos.toNodeList(camelContexts);
                if (camelContexts.size() == 1 && nodes.size() > 1) {
                    node.setDefaultValue((Object)nodes.get(1));
                }
                return nodes;
            }
        });
    }

    protected boolean isProjectRequired() {
        return true;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelDeleteNodeXmlCommand.class).name("Camel: Delete Node XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Deletes a node from a Camel XML file");
    }

    public boolean isEnabled(UIContext context) {
        Project project;
        boolean enabled = super.isEnabled(context);
        if (!enabled) {
            return false;
        }
        if (this.requiresCamelSetup() && (project = this.getSelectedProjectOrNull(context)) != null) {
            return this.findCamelCoreDependency(project) != null;
        }
        return false;
    }

    protected Project getSelectedProjectOrNull(UIContext context) {
        return Projects.getSelectedProject((ProjectFactory)this.getProjectFactory(), (UIContext)context);
    }

    protected boolean isRunningInGui(UIContext context) {
        return context.getProvider().isGUI();
    }

    protected boolean requiresCamelSetup() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }

    protected ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    protected CamelCatalog getCamelCatalog() {
        return this.camelCatalog;
    }

    protected PrintStream getOutput(UIExecutionContext context) {
        return context.getUIContext().getProvider().getOutput().out();
    }

    protected boolean isCamelProject(Project project) {
        return !this.findCamelArtifacts(project).isEmpty();
    }

    protected Dependency findCamelCoreDependency(Project project) {
        return CamelProjectHelper.findCamelCoreDependency((Project)project);
    }

    protected Set<Dependency> findCamelArtifacts(Project project) {
        return CamelProjectHelper.findCamelArtifacts((Project)project);
    }

    protected Coordinate createCoordinate(String groupId, String artifactId, String version) {
        CoordinateBuilder builder = CoordinateBuilder.create().setGroupId(groupId).setArtifactId(artifactId);
        if (version != null) {
            builder = builder.setVersion(version);
        }
        return builder;
    }

    protected Coordinate createCamelCoordinate(String artifactId, String version) {
        return this.createCoordinate("org.apache.camel", artifactId, version);
    }

    protected RouteBuilderCompleter createRouteBuilderCompleter(Project project) {
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        return new RouteBuilderCompleter(facet);
    }

    protected RouteBuilderEndpointsCompleter createRouteBuilderEndpointsCompleter(UIContext context, Function<String, Boolean> filter) {
        Project project = this.getSelectedProject(context);
        return this.createRouteBuilderEndpointsCompleter(project, filter);
    }

    protected RouteBuilderEndpointsCompleter createRouteBuilderEndpointsCompleter(Project project, Function<String, Boolean> filter) {
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        return new RouteBuilderEndpointsCompleter(facet, filter);
    }

    protected XmlEndpointsCompleter createXmlEndpointsCompleter(UIContext context, Function<String, Boolean> filter) {
        Project project = this.getSelectedProject(context);
        return this.createXmlEndpointsCompleter(project, filter);
    }

    protected XmlEndpointsCompleter createXmlEndpointsCompleter(Project project, Function<String, Boolean> filter) {
        ResourcesFacet resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        return new XmlEndpointsCompleter(resourcesFacet, webResourcesFacet, filter);
    }

    protected XmlFileCompleter createXmlFileCompleter(Project project, Function<String, Boolean> filter) {
        ResourcesFacet resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        return new XmlFileCompleter(resourcesFacet, webResourcesFacet, filter);
    }

    protected XmlFileCompleter createXmlFileCompleter(UIContext context, Function<String, Boolean> filter) {
        Project project = this.getSelectedProject(context);
        return this.createXmlFileCompleter(project, filter);
    }

    protected CurrentLineCompleter createCurrentLineCompleter(int lineNumber, String file, UIContext context) throws Exception {
        Project project = this.getSelectedProject(context);
        ResourcesFacet resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        String relativeFile = this.asRelativeFile(context, file);
        return new CurrentLineCompleter(lineNumber, relativeFile, resourcesFacet, webResourcesFacet);
    }

    protected FileResource getXmlResourceFile(Project project, String xmlResourceName) {
        FileResource file;
        ResourcesFacet facet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        FileResource fileResource = file = facet != null ? facet.getResource(xmlResourceName) : null;
        if (file == null || !file.exists()) {
            file = webResourcesFacet != null ? webResourcesFacet.getWebResource(xmlResourceName) : null;
        }
        return file;
    }

    protected String configureXml(Project project, UISelectOne<String> xml, String currentFile) {
        String first;
        XmlFileCompleter xmlFileCompleter = this.createXmlFileCompleter(project, null);
        Set<String> files = xmlFileCompleter.getFiles();
        String answer = first = CollectionHelper.first(files);
        xml.setValueChoices(files);
        if (files.size() == 1) {
            xml.setDefaultValue((Object)first);
        } else if (currentFile != null) {
            for (String name : files) {
                if (!currentFile.endsWith(name)) continue;
                xml.setDefaultValue((Object)name);
                answer = name;
                break;
            }
        }
        return answer;
    }

    protected String configureRouteBuilder(Project project, UISelectOne<String> routeBuilders, String currentFile) {
        String first;
        RouteBuilderCompleter completer = this.createRouteBuilderCompleter(project);
        Set<String> builders = completer.getRouteBuilders();
        String answer = first = CollectionHelper.first(builders);
        routeBuilders.setValueChoices(builders);
        if (builders.size() == 1) {
            routeBuilders.setDefaultValue((Object)first);
        } else if (currentFile != null) {
            if (currentFile.endsWith(".java")) {
                currentFile = currentFile.substring(0, currentFile.length() - 5);
            }
            for (String name : builders) {
                if (!currentFile.endsWith(name)) continue;
                routeBuilders.setDefaultValue((Object)name);
                answer = name;
                break;
            }
        }
        return answer;
    }

    protected void configureComponentName(Project project, final UISelectOne<ComponentDto> componentName, boolean consumerOnly, boolean producerOnly) throws Exception {
        Iterable<ComponentDto> it = CamelCommandsHelper.createComponentDtoValues(project, this.getCamelCatalog(), null, false, consumerOnly, producerOnly).call();
        final LinkedHashMap<String, ComponentDto> components = new LinkedHashMap<String, ComponentDto>();
        for (ComponentDto dto : it) {
            components.put(dto.getScheme(), dto);
        }
        componentName.setValueChoices(components.values());
        componentName.setValueConverter((Converter)new Converter<String, ComponentDto>(){

            public ComponentDto convert(String text) {
                return (ComponentDto)components.get(text);
            }
        });
        componentName.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent event) {
                ComponentDto component = (ComponentDto)event.getNewValue();
                if (component != null) {
                    String description = component.getDescription();
                    componentName.setNote(description != null ? description : "");
                } else {
                    componentName.setNote("");
                }
            }
        });
    }

    protected Element getSelectedCamelElementNode(Project project, String xmlResourceName, String key) throws Exception {
        FileResource file = this.getXmlResourceFile(project, xmlResourceName);
        InputStream resourceInputStream = file.getResourceInputStream();
        return CamelXmlHelper.getSelectedCamelElementNode(key, resourceInputStream);
    }

    protected String getSelectedFile(UIContext context) {
        String currentFile = null;
        Optional region = context.getSelection().getRegion();
        if (region.isPresent()) {
            Object resource = ((UIRegion)region.get()).getResource();
            currentFile = resource.toString();
        }
        return currentFile;
    }

    protected int getCurrentCursorLine(UIContext context) {
        int answer = -1;
        Optional region = context.getSelection().getRegion();
        if (region.isPresent()) {
            answer = ((UIRegion)region.get()).getStartLine();
        }
        return answer;
    }

    protected int getCurrentCursorPosition(UIContext context) {
        int answer = -1;
        Optional region = context.getSelection().getRegion();
        if (region.isPresent()) {
            answer = ((UIRegion)region.get()).getStartPosition();
        }
        return answer;
    }

    protected String asRelativeFile(UIContext context, String currentFile) {
        boolean javaFile = currentFile != null && currentFile.endsWith(".java");
        String target = null;
        if (!javaFile) {
            WebResourcesFacet facet2;
            Project project = this.getSelectedProject(context);
            ResourcesFacet facet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
            if (facet != null) {
                String baseDir = facet.getResourceDirectory().getFullyQualifiedName();
                String fqn = currentFile;
                if (fqn != null && fqn.startsWith(baseDir)) {
                    target = fqn.substring(baseDir.length() + 1);
                }
            }
            if (target == null && (facet2 = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class)) != null) {
                String baseDir = facet2.getWebRootDirectory().getFullyQualifiedName();
                String fqn = currentFile;
                if (fqn != null && fqn.startsWith(baseDir)) {
                    target = fqn.substring(baseDir.length() + 1);
                }
            }
        }
        return target != null ? target : currentFile;
    }
}

