/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.camel.commands.project.completer.XmlResourcesCamelEndpointsVisitor;
import java.util.Set;
import java.util.function.Function;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;
import org.jboss.forge.addon.resource.visit.VisitContext;

public class XmlResourcesCamelFilesVisitor
implements ResourceVisitor {
    private final ResourcesFacet facet;
    private final Set<String> files;
    private final Set<String> directories;
    private final Function<String, Boolean> filter;

    public XmlResourcesCamelFilesVisitor(ResourcesFacet facet, Set<String> files, Set<String> directories, Function<String, Boolean> filter) {
        this.facet = facet;
        this.files = files;
        this.directories = directories;
        this.filter = filter;
    }

    public void visit(VisitContext visitContext, Resource<?> resource) {
        String name = resource.getName();
        if (name.endsWith(".xml")) {
            boolean camel;
            boolean include = true;
            if (this.filter != null) {
                String fqn = resource.getFullyQualifiedName();
                Boolean out = this.filter.apply(fqn);
                boolean bl = include = out == null || out != false;
            }
            if (include && (camel = XmlResourcesCamelEndpointsVisitor.containsCamelRoutes(resource))) {
                String baseDir = this.facet.getResourceDirectory().getFullyQualifiedName();
                String fqn = resource.getFullyQualifiedName();
                if (fqn.startsWith(baseDir)) {
                    fqn = fqn.substring(baseDir.length() + 1);
                }
                this.files.add(fqn);
            }
        }
    }
}

