/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.LineNumberHelper;
import io.fabric8.forge.addon.utils.XmlLineNumberParser;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.dto.NodeDto;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import io.fabric8.forge.camel.commands.project.helper.StringHelper;
import io.fabric8.utils.Strings;
import java.io.InputStream;
import java.util.List;
import org.apache.camel.catalog.CamelCatalog;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EditFromOrToEndpointXmlStep
extends ConfigureEndpointPropertiesStep {
    private final NodeDto parentNode;
    private final boolean isFrom;

    public EditFromOrToEndpointXmlStep(ProjectFactory projectFactory, DependencyInstaller dependencyInstaller, CamelCatalog camelCatalog, String componentName, String group, List<InputComponent> allInputs, List<InputComponent> inputs, boolean last, int index, int total, NodeDto parentNode, boolean isFrom) {
        super(projectFactory, dependencyInstaller, camelCatalog, componentName, group, allInputs, inputs, last, index, total);
        this.parentNode = parentNode;
        this.isFrom = isFrom;
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConfigureEndpointPropertiesStep.class).name("Camel: Add Endpoint").category(Categories.create((String[])new String[]{CATEGORY})).description(String.format("Configure %s options (%s of %s)", this.getGroup(), this.getIndex(), this.getTotal()));
    }

    @Override
    protected Result addOrEditEndpointXml(FileResource file, String uri, String endpointUrl, String endpointInstanceName, String xml, String lineNumber, String lineNumberEnd) throws Exception {
        String key = this.parentNode.getKey();
        if (Strings.isNullOrBlank((String)key)) {
            return Results.fail((String)("Parent node has no key! " + this.parentNode + " in file " + file.getName()));
        }
        Document root = XmlLineNumberParser.parseXml((InputStream)file.getResourceInputStream());
        if (root != null) {
            Node selectedNode = CamelXmlHelper.findCamelNodeInDocument(root, key);
            if (selectedNode != null) {
                lineNumber = (String)selectedNode.getUserData("lineNumber");
                lineNumberEnd = (String)selectedNode.getUserData("lineNumberEnd");
                if (lineNumber != null && lineNumberEnd != null) {
                    List lines = LineNumberHelper.readLines((InputStream)file.getResourceInputStream());
                    int idx = Integer.valueOf(lineNumber) - 1;
                    String line = (String)lines.get(idx);
                    line = StringHelper.replaceAll(line, endpointUrl, uri);
                    lines.set(idx, line);
                    String content = LineNumberHelper.linesToString((List)lines);
                    file.setContents(content);
                    return Results.success((String)("Updated: " + line.trim()));
                }
            }
            return Results.fail((String)("Cannot find Camel node in XML file: " + key));
        }
        return Results.fail((String)("Cannot load Camel XML file: " + file.getName()));
    }
}

